/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.manage;

import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.check.CheckType;
import com.rammelkast.anticheatreloaded.config.Configuration;
import com.rammelkast.anticheatreloaded.manage.AntiCheatManager;
import com.rammelkast.anticheatreloaded.util.Group;
import com.rammelkast.anticheatreloaded.util.User;
import com.rammelkast.anticheatreloaded.util.Utilities;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class UserManager {
    private List<User> users = new ArrayList<User>();
    private AntiCheatManager manager;
    private Configuration config;

    public UserManager(AntiCheatManager manager) {
        this.manager = manager;
        this.config = manager.getConfiguration();
    }

    public User getUser(UUID uuid) {
        for (User user : this.users) {
            if (!user.getUUID().equals(uuid)) continue;
            return user;
        }
        User user = new User(uuid);
        user.setIsWaitingOnLevelSync(true);
        this.config.getLevels().loadLevelToUser(user);
        return user;
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void addUser(User user) {
        this.users.add(user);
    }

    public void remove(User user) {
        this.users.remove(user);
    }

    public void saveLevel(User user) {
        this.config.getLevels().saveLevelFromUser(user);
    }

    public List<User> getUsersInGroup(Group group) {
        ArrayList<User> list = new ArrayList<User>();
        for (User u : this.users) {
            if (u.getGroup() != group) continue;
            list.add(u);
        }
        return list;
    }

    public int safeGetLevel(UUID uuid) {
        User user = this.getUser(uuid);
        if (user == null) {
            return 0;
        }
        return user.getLevel();
    }

    public void safeSetLevel(UUID uuid, int level) {
        User user = this.getUser(uuid);
        if (user != null) {
            user.setLevel(level);
        }
    }

    public void safeReset(UUID uuid) {
        User user = this.getUser(uuid);
        if (user != null) {
            user.resetLevel();
        }
    }

    public void alert(User user, Group group, CheckType type) {
        this.execute(user, group.getActions(), type);
    }

    public void execute(User user, List<String> actions, CheckType type) {
        this.execute(user, actions, type, this.config.getLang().KICK_REASON(), this.config.getLang().WARNING(), this.config.getLang().BAN_REASON());
    }

    public void execute(final User user, final List<String> actions, final CheckType type, final String kickReason, final List<String> warning, final String banReason) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)AntiCheatReloaded.getPlugin(), new Runnable(){

            @Override
            public void run() {
                if (user.getPlayer() == null) {
                    return;
                }
                String name = user.getName();
                for (String event : actions) {
                    String msg;
                    if ((event = event.replaceAll("%player%", name).replaceAll("%world%", user.getPlayer().getWorld().getName()).replaceAll("%check%", type.name())).startsWith("COMMAND[")) {
                        for (String cmd : Utilities.getCommands(event)) {
                            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), cmd);
                        }
                        continue;
                    }
                    if (event.equalsIgnoreCase("KICK")) {
                        user.getPlayer().kickPlayer(ChatColor.translateAlternateColorCodes((char)'&', (String)kickReason));
                        AntiCheatReloaded.getPlugin().onPlayerKicked();
                        msg = ChatColor.translateAlternateColorCodes((char)'&', (String)(UserManager.this.config.getLang().KICK_BROADCAST().replaceAll("%player%", name) + " (" + type.getName() + ")"));
                        if (msg.equals("")) continue;
                        UserManager.this.manager.log(msg);
                        UserManager.this.manager.playerLog(msg);
                        continue;
                    }
                    if (event.equalsIgnoreCase("WARN")) {
                        List message = warning;
                        for (String string : message) {
                            if (string.equals("")) continue;
                            user.getPlayer().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
                        }
                        continue;
                    }
                    if (event.equalsIgnoreCase("BAN")) {
                        Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(user.getPlayer().getName(), ChatColor.translateAlternateColorCodes((char)'&', (String)banReason), null, null);
                        user.getPlayer().kickPlayer(ChatColor.translateAlternateColorCodes((char)'&', (String)banReason));
                        msg = ChatColor.translateAlternateColorCodes((char)'&', (String)(UserManager.this.config.getLang().BAN_BROADCAST().replaceAll("%player%", name) + " (" + type.getName() + ")"));
                        if (msg.equals("")) continue;
                        UserManager.this.manager.log(msg);
                        UserManager.this.manager.playerLog(msg);
                        continue;
                    }
                    if (!event.equalsIgnoreCase("RESET")) continue;
                    user.resetLevel();
                }
            }
        });
    }
}

