/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.util;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.injector.server.TemporaryPlayer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.check.movement.NoSlowCheck;
import com.rammelkast.anticheatreloaded.check.packet.BadPacketsCheck;
import com.rammelkast.anticheatreloaded.check.packet.MorePacketsCheck;
import com.rammelkast.anticheatreloaded.util.User;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketListener {
    public static void listenMovementPackets() {
        AntiCheatReloaded.getProtocolManager().addPacketListener((com.comphenix.protocol.events.PacketListener)new PacketAdapter((Plugin)AntiCheatReloaded.getPlugin(), ListenerPriority.LOWEST, new PacketType[]{PacketType.Play.Client.POSITION, PacketType.Play.Client.POSITION_LOOK, PacketType.Play.Server.POSITION}){

            public void onPacketReceiving(PacketEvent event) {
                Player player = event.getPlayer();
                if (player == null || !player.isOnline()) {
                    return;
                }
                MorePacketsCheck.runCheck(player, event);
                if (!event.isCancelled()) {
                    BadPacketsCheck.runCheck(player, event);
                }
            }

            public void onPacketSending(PacketEvent event) {
                Player player = event.getPlayer();
                if (player instanceof TemporaryPlayer) {
                    return;
                }
                MorePacketsCheck.compensate(player);
            }
        });
    }

    public static void listenKeepAlivePackets() {
        AntiCheatReloaded.getProtocolManager().addPacketListener((com.comphenix.protocol.events.PacketListener)new PacketAdapter((Plugin)AntiCheatReloaded.getPlugin(), ListenerPriority.LOWEST, new PacketType[]{PacketType.Play.Client.KEEP_ALIVE, PacketType.Play.Server.KEEP_ALIVE}){

            public void onPacketSending(PacketEvent event) {
                User user = AntiCheatReloaded.getManager().getUserManager().getUser(event.getPlayer().getUniqueId());
                user.onServerPing();
            }

            public void onPacketReceiving(PacketEvent event) {
                User user = AntiCheatReloaded.getManager().getUserManager().getUser(event.getPlayer().getUniqueId());
                user.onClientPong();
            }
        });
    }

    public static void listenUseItemPackets() {
        AntiCheatReloaded.getProtocolManager().addPacketListener((com.comphenix.protocol.events.PacketListener)new PacketAdapter((Plugin)AntiCheatReloaded.getPlugin(), ListenerPriority.LOWEST, new PacketType[]{PacketType.Play.Client.BLOCK_DIG}){

            public void onPacketReceiving(PacketEvent event) {
                if (event.getPacket().getPlayerDigTypes().read(0) == EnumWrappers.PlayerDigType.RELEASE_USE_ITEM) {
                    NoSlowCheck.runCheck(event.getPlayer(), event);
                }
            }
        });
    }
}

