/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.util;

import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;

public class UpdateManager {
    public static final int RESOURCE_ID = 23799;
    public static final String SPIGOT_VERSION_URL = "https://api.spigotmc.org/legacy/update.php?resource=23799";
    private String latestVersion;
    private boolean isLatest;
    private boolean isAhead;

    public UpdateManager() {
        this.update();
    }

    public void update() {
        this.latestVersion = this.getOnlineData(SPIGOT_VERSION_URL);
        if (this.latestVersion == null) {
            this.isLatest = true;
            this.isAhead = false;
            return;
        }
        int splitCompare = 0;
        try {
            VersionSplit currentSplit = new VersionSplit(AntiCheatReloaded.getVersion());
            VersionSplit newSplit = new VersionSplit(this.latestVersion);
            splitCompare = currentSplit.compareTo(newSplit);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isLatest = splitCompare >= 0;
        this.isAhead = splitCompare > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOnlineData(String url) {
        String data = null;
        InputStream stream = null;
        try {
            int readChar;
            stream = new URL(url).openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, Charset.forName("UTF-8")));
            StringBuilder builder = new StringBuilder();
            while ((readChar = reader.read()) != -1) {
                builder.append((char)readChar);
            }
            data = builder.toString();
            reader.close();
        }
        catch (IOException iOException) {
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return data;
    }

    public boolean isLatest() {
        return this.isLatest;
    }

    public boolean isAhead() {
        return this.isAhead;
    }

    public String getCurrentVersion() {
        return AntiCheatReloaded.getVersion();
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public class VersionSplit
    implements Comparable<VersionSplit> {
        private final int major;
        private final int minor;
        private final int build;

        public VersionSplit(String version) throws Exception {
            if (version.endsWith("-ALPHA")) {
                version = version.substring(0, version.length() - 6);
            } else if (version.endsWith("-PRE")) {
                version = version.substring(0, version.length() - 4);
            }
            String[] versionSplit = version.split("\\.");
            if (versionSplit.length != 3) {
                throw new Exception("Version " + version + " is illegal!");
            }
            try {
                int major = Integer.parseInt(versionSplit[0]);
                int minor = Integer.parseInt(versionSplit[1]);
                int build = Integer.parseInt(versionSplit[2]);
                if (major <= 0) {
                    throw new Exception("Illegal version!");
                }
                this.major = major;
                this.minor = minor;
                this.build = build;
            }
            catch (Exception e) {
                throw new Exception("Illegal version!");
            }
        }

        @Override
        public int compareTo(VersionSplit other) {
            if (other.major == this.major) {
                if (other.minor == this.minor) {
                    if (other.build == this.build) {
                        return 0;
                    }
                    if (other.build > this.build) {
                        return -1;
                    }
                    return 1;
                }
                if (other.minor > this.minor) {
                    return -1;
                }
                return 1;
            }
            if (other.major > this.major) {
                return -1;
            }
            return 1;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getBuild() {
            return this.build;
        }
    }
}

