/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.util;

import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.check.CheckType;
import com.rammelkast.anticheatreloaded.config.Configuration;
import com.rammelkast.anticheatreloaded.util.Group;
import com.rammelkast.anticheatreloaded.util.MovementManager;
import com.rammelkast.anticheatreloaded.util.Utilities;
import com.rammelkast.anticheatreloaded.util.VersionUtil;
import com.rammelkast.anticheatreloaded.util.rule.Rule;
import java.sql.Timestamp;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class User {
    private final UUID uuid;
    private final String name;
    private final int id;
    private int level = 0;
    private Location goodLocation;
    private Configuration config = AntiCheatReloaded.getManager().getConfiguration();
    private int toX;
    private int toY;
    private int toZ;
    private String[] messages = new String[2];
    private Long[] messageTimes = new Long[2];
    private String[] commands = new String[2];
    private Long[] commandTimes = new Long[2];
    private boolean isWaitingOnLevelSync;
    private Timestamp levelSyncTimestamp;
    private long lastServerPing;
    private long lastClientPong;
    private int ping = -1;
    private int lastPing = -1;
    private MovementManager movementManager;

    public User(UUID uuid) {
        this.uuid = uuid;
        this.name = this.getPlayer() != null && this.getPlayer().isOnline() ? this.getPlayer().getName() : "";
        this.id = this.getPlayer() != null && this.getPlayer().isOnline() ? this.getPlayer().getEntityId() : -1;
        this.movementManager = new MovementManager();
        this.ping = this.getPlayer() != null && this.getPlayer().isOnline() ? VersionUtil.getPlayerPing(this.getPlayer()) : -1;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    public int getLevel() {
        return this.level;
    }

    public Group getGroup() {
        List<Group> groups = this.config.getGroups().getGroups();
        for (int i = 0; i < groups.size() && (i != 0 || this.level >= groups.get(i).getLevel()); ++i) {
            if (i == groups.size() - 1) {
                return groups.get(i);
            }
            if (this.level < groups.get(i).getLevel() || this.level >= groups.get(i + 1).getLevel()) continue;
            return groups.get(i);
        }
        return null;
    }

    public boolean increaseLevel(CheckType type) {
        if (this.getPlayer() != null && this.getPlayer().isOnline()) {
            if (this.silentMode() && type.getUses(this.uuid) % 4 != 0) {
                return false;
            }
            if (this.level < this.config.getGroups().getHighestLevel()) {
                ++this.level;
                for (Group l : this.getLevels()) {
                    if (l.getLevel() != this.level) continue;
                    AntiCheatReloaded.getManager().getUserManager().alert(this, l, type);
                    if (l.getLevel() != this.config.getGroups().getHighestLevel()) continue;
                    this.level = l.getLevel() - 10;
                }
                for (Rule rule : this.config.getRules().getRules()) {
                    rule.check(this, type);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void decreaseLevel() {
        this.level = this.level != 0 ? this.level - 1 : 0;
    }

    public boolean setLevel(int level) {
        this.isWaitingOnLevelSync = false;
        if (level >= 0) {
            if (level <= this.config.getGroups().getHighestLevel()) {
                this.level = level;
                return true;
            }
            this.level = this.config.getGroups().getHighestLevel();
            return false;
        }
        return false;
    }

    public void resetLevel() {
        this.level = 0;
        for (CheckType type : CheckType.values()) {
            type.clearUse(this.uuid);
        }
    }

    public Location getGoodLocation(Location location) {
        if (this.goodLocation == null || !location.getWorld().equals(this.goodLocation.getWorld()) || location.distance(this.goodLocation) > (double)this.config.getConfig().maxSetbackDistance.getValue().intValue()) {
            return location;
        }
        Location moveTo = this.goodLocation;
        if (location != null) {
            moveTo.setPitch(location.getPitch());
            moveTo.setYaw(location.getYaw());
        }
        return moveTo;
    }

    public boolean setGoodLocation(Location location) {
        if (Utilities.cantStandAtExp(location)) {
            return false;
        }
        this.goodLocation = location;
        return true;
    }

    public void setTo(double x, double y, double z) {
        this.toX = (int)x;
        this.toY = (int)y;
        this.toZ = (int)z;
    }

    public boolean checkTo(double x, double y, double z) {
        return (int)x == this.toX && (int)y == this.toY && (int)z == this.toZ;
    }

    public void addMessage(String message) {
        this.addToSpamLog(message, this.messages, this.messageTimes);
    }

    public void addCommand(String command) {
        this.addToSpamLog(command, this.commands, this.commandTimes);
    }

    private void addToSpamLog(String string, String[] messages, Long[] times) {
        messages[1] = messages[0];
        messages[0] = string;
        times[1] = times[0];
        times[0] = System.currentTimeMillis();
    }

    public String getMessage(int index) {
        return this.messages[index];
    }

    public String getCommand(int index) {
        return this.commands[index];
    }

    public Long getMessageTime(int index) {
        return this.messageTimes[index];
    }

    public Long getCommandTime(int index) {
        return this.commandTimes[index];
    }

    public void clearMessages() {
        this.messages = new String[2];
        this.messageTimes = new Long[2];
    }

    public void clearCommands() {
        this.commands = new String[2];
        this.commandTimes = new Long[2];
    }

    public Long getLastMessageTime() {
        return this.getMessageTime(0) == null ? -1L : this.getMessageTime(0);
    }

    public Long getLastCommandTime() {
        return this.getCommandTime(0) == null ? -1L : this.getCommandTime(0);
    }

    private List<Group> getLevels() {
        return this.config.getGroups().getGroups();
    }

    private boolean silentMode() {
        return this.config.getConfig().silentMode.getValue();
    }

    public void setIsWaitingOnLevelSync(boolean b) {
        this.isWaitingOnLevelSync = b;
    }

    public boolean isWaitingOnLevelSync() {
        return this.isWaitingOnLevelSync;
    }

    public void setLevelSyncTimestamp(Timestamp timestamp) {
        this.levelSyncTimestamp = timestamp;
    }

    public Timestamp getLevelSyncTimestamp() {
        return this.levelSyncTimestamp;
    }

    public void onServerPing() {
        this.lastServerPing = System.currentTimeMillis();
    }

    public void onClientPong() {
        this.lastClientPong = System.currentTimeMillis();
        this.lastPing = this.ping;
        this.ping = (int)(this.lastClientPong - this.lastServerPing);
    }

    public int getPing() {
        int ping = this.ping;
        if (ping < 0) {
            return VersionUtil.getPlayerPing(this.getPlayer());
        }
        return ping;
    }

    public int getLastPing() {
        int lastPing = this.lastPing;
        if (lastPing < 0) {
            return this.getPing();
        }
        return lastPing;
    }

    public boolean isLagging() {
        return Math.abs(this.ping - this.lastPing) > this.config.getMagic().LAG_DETERMINATION() && this.ping > this.config.getMagic().LAG_DETERMINATION();
    }

    public MovementManager getMovementManager() {
        return this.movementManager;
    }

    public String toString() {
        return "User {name = " + this.getName() + ", level = " + this.level + "}";
    }
}

