/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.util;

import com.rammelkast.anticheatreloaded.util.MinecraftVersion;
import com.rammelkast.anticheatreloaded.util.VersionUtil;
import com.rammelkast.anticheatreloaded.util.XMaterial;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.NumberConversions;

public final class Utilities {
    private static final List<Material> INSTANT_BREAK = new ArrayList<Material>();
    private static final List<Material> FOOD = new ArrayList<Material>();
    private static final List<Material> CLIMBABLE = new ArrayList<Material>();
    private static final Map<Material, Material> COMBO = new HashMap<Material, Material>();
    public static final double JUMP_MOTION_Y = (double)0.42f;

    public static boolean cantStandAtSingle(Block block) {
        Block otherBlock = block.getLocation().add(0.0, -0.5, 0.0).getBlock();
        boolean center = otherBlock.getType() == Material.AIR;
        return center;
    }

    public static boolean cantStandAt(Block block) {
        return !Utilities.canStand(block) && Utilities.cantStandClose(block) && Utilities.cantStandFar(block);
    }

    public static boolean cantStandAtExp(Location location) {
        return Utilities.cantStandAt(new Location(location.getWorld(), Utilities.fixXAxis(location.getX()), location.getY() - 0.01, (double)location.getBlockZ()).getBlock());
    }

    public static boolean cantStandClose(Block block) {
        return !Utilities.canStand(block.getRelative(BlockFace.NORTH)) && !Utilities.canStand(block.getRelative(BlockFace.EAST)) && !Utilities.canStand(block.getRelative(BlockFace.SOUTH)) && !Utilities.canStand(block.getRelative(BlockFace.WEST));
    }

    public static boolean cantStandFar(Block block) {
        return !Utilities.canStand(block.getRelative(BlockFace.NORTH_WEST)) && !Utilities.canStand(block.getRelative(BlockFace.NORTH_EAST)) && !Utilities.canStand(block.getRelative(BlockFace.SOUTH_WEST)) && !Utilities.canStand(block.getRelative(BlockFace.SOUTH_EAST));
    }

    public static boolean canStand(Block block) {
        return !block.isLiquid() && block.getType() != Material.AIR;
    }

    public static boolean isNotNearSlime(Block block) {
        return !Utilities.isSlime(block.getRelative(BlockFace.NORTH)) && !Utilities.isSlime(block.getRelative(BlockFace.EAST)) && !Utilities.isSlime(block.getRelative(BlockFace.SOUTH)) && !Utilities.isSlime(block.getRelative(BlockFace.WEST)) && !Utilities.isSlime(block.getRelative(BlockFace.DOWN));
    }

    public static boolean couldBeOnBoat(Player player) {
        return Utilities.couldBeOnBoat(player, 0.35, false);
    }

    public static boolean couldBeOnBoat(Player player, double range, boolean checkY) {
        for (Entity entity : player.getNearbyEntities(range, range, range)) {
            if (!(entity instanceof Boat)) continue;
            if (((Boat)entity).getLocation().getY() < player.getLocation().getY() + 0.35) {
                return true;
            }
            if (checkY) continue;
            return true;
        }
        return false;
    }

    public static boolean couldBeOnIce(Location location) {
        return Utilities.isNearIce(new Location(location.getWorld(), Utilities.fixXAxis(location.getX()), location.getY() - 0.01, (double)location.getBlockZ())) || Utilities.isNearIce(new Location(location.getWorld(), Utilities.fixXAxis(location.getX()), location.getY() - 0.26, (double)location.getBlockZ()));
    }

    public static boolean isIce(Block block) {
        Material type = block.getType();
        return type.name().endsWith("ICE");
    }

    public static boolean isNearIce(Location location) {
        return Utilities.isIce(location.getBlock()) || Utilities.isIce(location.getBlock().getRelative(BlockFace.NORTH)) || Utilities.isIce(location.getBlock().getRelative(BlockFace.SOUTH)) || Utilities.isIce(location.getBlock().getRelative(BlockFace.EAST)) || Utilities.isIce(location.getBlock().getRelative(BlockFace.WEST)) || Utilities.isIce(location.getBlock().getRelative(BlockFace.NORTH_EAST)) || Utilities.isIce(location.getBlock().getRelative(BlockFace.NORTH_WEST)) || Utilities.isIce(location.getBlock().getRelative(BlockFace.SOUTH_EAST)) || Utilities.isIce(location.getBlock().getRelative(BlockFace.SOUTH_WEST));
    }

    public static boolean isShulkerBox(Block block) {
        Material type = block.getType();
        return type.name().endsWith("SHULKER_BOX");
    }

    public static boolean isNearShulkerBox(Location location) {
        if (MinecraftVersion.getCurrentVersion().isAtLeast(MinecraftVersion.COLOR_UPDATE)) {
            return false;
        }
        return Utilities.isShulkerBox(location.getBlock()) || Utilities.isShulkerBox(location.getBlock().getRelative(BlockFace.NORTH)) || Utilities.isShulkerBox(location.getBlock().getRelative(BlockFace.SOUTH)) || Utilities.isShulkerBox(location.getBlock().getRelative(BlockFace.EAST)) || Utilities.isShulkerBox(location.getBlock().getRelative(BlockFace.WEST)) || Utilities.isShulkerBox(location.getBlock().getRelative(BlockFace.NORTH_EAST)) || Utilities.isShulkerBox(location.getBlock().getRelative(BlockFace.NORTH_WEST)) || Utilities.isShulkerBox(location.getBlock().getRelative(BlockFace.SOUTH_EAST)) || Utilities.isShulkerBox(location.getBlock().getRelative(BlockFace.SOUTH_WEST));
    }

    public static boolean couldBeOnHalfblock(Location location) {
        return Utilities.isNearHalfblock(new Location(location.getWorld(), location.getX(), location.getY() - 0.01, (double)location.getBlockZ())) || Utilities.isNearHalfblock(new Location(location.getWorld(), location.getX(), location.getY() - 0.51, (double)location.getBlockZ()));
    }

    public static boolean isNearHalfblock(Location location) {
        return Utilities.isHalfblock(location.getBlock()) || Utilities.isHalfblock(location.getBlock().getRelative(BlockFace.NORTH)) || Utilities.isHalfblock(location.getBlock().getRelative(BlockFace.SOUTH)) || Utilities.isHalfblock(location.getBlock().getRelative(BlockFace.EAST)) || Utilities.isHalfblock(location.getBlock().getRelative(BlockFace.WEST)) || Utilities.isHalfblock(location.getBlock().getRelative(BlockFace.NORTH_EAST)) || Utilities.isHalfblock(location.getBlock().getRelative(BlockFace.NORTH_WEST)) || Utilities.isHalfblock(location.getBlock().getRelative(BlockFace.SOUTH_EAST)) || Utilities.isHalfblock(location.getBlock().getRelative(BlockFace.SOUTH_WEST));
    }

    public static boolean isHalfblock(Block block) {
        BoundingBox box;
        double height;
        if (MinecraftVersion.getCurrentVersion().isAtLeast(MinecraftVersion.VILLAGE_UPDATE) && (height = (box = block.getBoundingBox()).getMaxY() - box.getMinY()) > 0.42 && height <= 0.6 && block.getType().isSolid()) {
            return true;
        }
        return Utilities.isSlab(block) || Utilities.isStair(block) || Utilities.isWall(block) || block.getType() == Material.SNOW || block.getType().name().endsWith("HEAD");
    }

    public static boolean couldBeOnSlime(Location location) {
        return Utilities.isNearSlime(new Location(location.getWorld(), Utilities.fixXAxis(location.getX()), location.getY() - 0.01, (double)location.getBlockZ())) || Utilities.isNearSlime(new Location(location.getWorld(), Utilities.fixXAxis(location.getX()), location.getY() - 0.51, (double)location.getBlockZ()));
    }

    public static boolean isSlime(Block block) {
        Material type = block.getType();
        return type.equals((Object)XMaterial.SLIME_BLOCK.parseMaterial());
    }

    public static boolean isNearSlime(Location location) {
        return Utilities.isSlime(location.getBlock()) || Utilities.isSlime(location.getBlock().getRelative(BlockFace.NORTH)) || Utilities.isSlime(location.getBlock().getRelative(BlockFace.SOUTH)) || Utilities.isSlime(location.getBlock().getRelative(BlockFace.EAST)) || Utilities.isSlime(location.getBlock().getRelative(BlockFace.WEST)) || Utilities.isSlime(location.getBlock().getRelative(BlockFace.NORTH_EAST)) || Utilities.isSlime(location.getBlock().getRelative(BlockFace.NORTH_WEST)) || Utilities.isSlime(location.getBlock().getRelative(BlockFace.SOUTH_EAST)) || Utilities.isSlime(location.getBlock().getRelative(BlockFace.SOUTH_WEST));
    }

    public static boolean isFullyInWater(Location player) {
        double touchedX = Utilities.fixXAxis(player.getX());
        if (!new Location(player.getWorld(), touchedX, player.getY(), (double)player.getBlockZ()).getBlock().isLiquid() && !new Location(player.getWorld(), touchedX, (double)Math.round(player.getY()), (double)player.getBlockZ()).getBlock().isLiquid()) {
            return true;
        }
        return new Location(player.getWorld(), touchedX, player.getY(), (double)player.getBlockZ()).getBlock().isLiquid() && new Location(player.getWorld(), touchedX, (double)Math.round(player.getY()), (double)player.getBlockZ()).getBlock().isLiquid();
    }

    public static double fixXAxis(double x) {
        double touchedX = x;
        double rem = touchedX - (double)Math.round(touchedX) + 0.01;
        if (rem < 0.3) {
            touchedX = NumberConversions.floor((double)x) - 1;
        }
        return touchedX;
    }

    public static boolean isHoveringOverWater(Location player, int blocks) {
        for (int i = player.getBlockY(); i > player.getBlockY() - blocks; --i) {
            Block newloc = new Location(player.getWorld(), (double)player.getBlockX(), (double)i, (double)player.getBlockZ()).getBlock();
            if (newloc.getType() == Material.AIR) continue;
            return newloc.isLiquid();
        }
        return false;
    }

    public static boolean isHoveringOverWater(Location player) {
        return Utilities.isHoveringOverWater(player, 25);
    }

    public static boolean isInstantBreak(Material m) {
        return INSTANT_BREAK.contains(m);
    }

    public static boolean isFood(Material m) {
        return FOOD.contains(m);
    }

    public static boolean isSlab(Block block) {
        Material type = block.getType();
        return type.name().endsWith("SLAB");
    }

    public static boolean isBed(Block block) {
        Material type = block.getType();
        return type.name().endsWith("BED");
    }

    public static boolean isNearBed(Location location) {
        return Utilities.isBed(location.getBlock()) || Utilities.isBed(location.getBlock().getRelative(BlockFace.NORTH)) || Utilities.isBed(location.getBlock().getRelative(BlockFace.SOUTH)) || Utilities.isBed(location.getBlock().getRelative(BlockFace.EAST)) || Utilities.isBed(location.getBlock().getRelative(BlockFace.WEST)) || Utilities.isBed(location.getBlock().getRelative(BlockFace.NORTH_EAST)) || Utilities.isBed(location.getBlock().getRelative(BlockFace.NORTH_WEST)) || Utilities.isBed(location.getBlock().getRelative(BlockFace.SOUTH_EAST)) || Utilities.isBed(location.getBlock().getRelative(BlockFace.SOUTH_WEST));
    }

    public static boolean isStair(Block block) {
        Material type = block.getType();
        return type.name().endsWith("STAIRS");
    }

    public static boolean isWall(Block block) {
        Material type = block.getType();
        return type.name().endsWith("WALL") || type.name().endsWith("FENCE");
    }

    public static boolean sprintFly(Player player) {
        return player.isSprinting() || player.isFlying();
    }

    public static boolean isOnLilyPad(Player player) {
        Block block = player.getLocation().getBlock();
        return block.getType() == XMaterial.LILY_PAD.parseMaterial() || block.getRelative(BlockFace.NORTH).getType() == XMaterial.LILY_PAD.parseMaterial() || block.getRelative(BlockFace.SOUTH).getType() == XMaterial.LILY_PAD.parseMaterial() || block.getRelative(BlockFace.EAST).getType() == XMaterial.LILY_PAD.parseMaterial() || block.getRelative(BlockFace.WEST).getType() == XMaterial.LILY_PAD.parseMaterial();
    }

    public static boolean isSubmersed(Player player) {
        return player.getLocation().getBlock().isLiquid() && player.getLocation().getBlock().getRelative(BlockFace.UP).isLiquid();
    }

    public static boolean isInWater(Player player) {
        return player.getLocation().getBlock().isLiquid() || player.getLocation().getBlock().getRelative(BlockFace.DOWN).isLiquid() || player.getLocation().getBlock().getRelative(BlockFace.UP).isLiquid() || MinecraftVersion.getCurrentVersion().isAtLeast(MinecraftVersion.AQUATIC_UPDATE) && (player.getLocation().getBlock().getType() == XMaterial.KELP_PLANT.parseMaterial() || player.getLocation().getBlock().getRelative(BlockFace.UP).getType() == XMaterial.KELP_PLANT.parseMaterial() || player.getLocation().getBlock().getRelative(BlockFace.DOWN).getType() == XMaterial.KELP_PLANT.parseMaterial()) && Utilities.isNearWater(player);
    }

    public static boolean isNearWater(Player player) {
        return player.getLocation().getBlock().isLiquid() || player.getLocation().getBlock().getRelative(BlockFace.UP).isLiquid() || player.getLocation().getBlock().getRelative(BlockFace.DOWN).isLiquid() || player.getLocation().getBlock().getRelative(BlockFace.NORTH).isLiquid() || player.getLocation().getBlock().getRelative(BlockFace.SOUTH).isLiquid() || player.getLocation().getBlock().getRelative(BlockFace.EAST).isLiquid() || player.getLocation().getBlock().getRelative(BlockFace.WEST).isLiquid() || player.getLocation().getBlock().getRelative(BlockFace.NORTH_EAST).isLiquid() || player.getLocation().getBlock().getRelative(BlockFace.NORTH_WEST).isLiquid() || player.getLocation().getBlock().getRelative(BlockFace.SOUTH_EAST).isLiquid() || player.getLocation().getBlock().getRelative(BlockFace.SOUTH_WEST).isLiquid();
    }

    public static boolean isNearWater(Location location) {
        return location.getBlock().isLiquid() || location.getBlock().getRelative(BlockFace.UP).isLiquid() || location.getBlock().getRelative(BlockFace.DOWN).isLiquid() || location.getBlock().getRelative(BlockFace.NORTH).isLiquid() || location.getBlock().getRelative(BlockFace.SOUTH).isLiquid() || location.getBlock().getRelative(BlockFace.EAST).isLiquid() || location.getBlock().getRelative(BlockFace.WEST).isLiquid() || location.getBlock().getRelative(BlockFace.NORTH_EAST).isLiquid() || location.getBlock().getRelative(BlockFace.NORTH_WEST).isLiquid() || location.getBlock().getRelative(BlockFace.SOUTH_EAST).isLiquid() || location.getBlock().getRelative(BlockFace.SOUTH_WEST).isLiquid();
    }

    public static boolean isSurroundedByWater(Player player) {
        Location location = player.getLocation().clone().subtract(0.0, 0.1, 0.0);
        return location.getBlock().isLiquid() && location.getBlock().getRelative(BlockFace.NORTH).isLiquid() && location.getBlock().getRelative(BlockFace.SOUTH).isLiquid() && location.getBlock().getRelative(BlockFace.EAST).isLiquid() && location.getBlock().getRelative(BlockFace.WEST).isLiquid() && location.getBlock().getRelative(BlockFace.NORTH_EAST).isLiquid() && location.getBlock().getRelative(BlockFace.NORTH_WEST).isLiquid() && location.getBlock().getRelative(BlockFace.SOUTH_EAST).isLiquid() && location.getBlock().getRelative(BlockFace.SOUTH_WEST).isLiquid();
    }

    public static boolean isNearWeb(Player player) {
        return Utilities.isWeb(player.getLocation().getBlock()) || Utilities.isWeb(player.getLocation().getBlock().getRelative(BlockFace.DOWN)) || Utilities.isWeb(player.getLocation().getBlock().getRelative(BlockFace.UP)) || Utilities.isWeb(player.getLocation().getBlock().getRelative(BlockFace.NORTH)) || Utilities.isWeb(player.getLocation().getBlock().getRelative(BlockFace.SOUTH)) || Utilities.isWeb(player.getLocation().getBlock().getRelative(BlockFace.EAST)) || Utilities.isWeb(player.getLocation().getBlock().getRelative(BlockFace.WEST));
    }

    public static boolean isWeb(Block block) {
        return block.getType() == XMaterial.COBWEB.parseMaterial();
    }

    public static boolean isInWeb(Player player) {
        return player.getLocation().getBlock().getType() == XMaterial.COBWEB.parseMaterial() || player.getLocation().getBlock().getRelative(BlockFace.DOWN).getType() == XMaterial.COBWEB.parseMaterial() || player.getLocation().getBlock().getRelative(BlockFace.UP).getType() == XMaterial.COBWEB.parseMaterial();
    }

    public static boolean isNearClimbable(Player player) {
        return Utilities.isClimbableBlock(player.getLocation().getBlock()) || Utilities.isClimbableBlock(player.getLocation().getBlock().getRelative(BlockFace.DOWN)) || Utilities.isClimbableBlock(player.getLocation().getBlock().getRelative(BlockFace.UP)) || Utilities.isClimbableBlock(player.getLocation().getBlock().getRelative(BlockFace.NORTH)) || Utilities.isClimbableBlock(player.getLocation().getBlock().getRelative(BlockFace.SOUTH)) || Utilities.isClimbableBlock(player.getLocation().getBlock().getRelative(BlockFace.EAST)) || Utilities.isClimbableBlock(player.getLocation().getBlock().getRelative(BlockFace.WEST));
    }

    public static boolean isNearClimbable(Location location) {
        return Utilities.isClimbableBlock(location.getBlock()) || Utilities.isClimbableBlock(location.getBlock().getRelative(BlockFace.DOWN)) || Utilities.isClimbableBlock(location.getBlock().getRelative(BlockFace.UP)) || Utilities.isClimbableBlock(location.getBlock().getRelative(BlockFace.NORTH)) || Utilities.isClimbableBlock(location.getBlock().getRelative(BlockFace.SOUTH)) || Utilities.isClimbableBlock(location.getBlock().getRelative(BlockFace.EAST)) || Utilities.isClimbableBlock(location.getBlock().getRelative(BlockFace.WEST));
    }

    public static boolean isClimbableBlock(Block block) {
        return CLIMBABLE.contains(block.getType());
    }

    public static boolean isOnVine(Player player) {
        return player.getLocation().getBlock().getType() == XMaterial.VINE.parseMaterial();
    }

    public static boolean isInt(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isDouble(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean blockIsnt(Block block, Material[] materials) {
        Material type = block.getType();
        for (Material m : materials) {
            if (m != type) continue;
            return false;
        }
        return true;
    }

    public static boolean blockIsnt(Block block, String[] endTypes) {
        Material type = block.getType();
        for (String s : endTypes) {
            if (!type.name().endsWith(s)) continue;
            return false;
        }
        return true;
    }

    public static String[] getCommands(String command) {
        return command.replaceAll("COMMAND\\[", "").replaceAll("]", "").split(";");
    }

    public static String removeWhitespace(String string) {
        return string.replaceAll(" ", "");
    }

    public static boolean hasArmorEnchantment(Player player, Enchantment e) {
        for (ItemStack is : player.getInventory().getArmorContents()) {
            if (is == null || !is.containsEnchantment(e)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<String> stringToList(final String string) {
        return new ArrayList<String>(){
            private static final long serialVersionUID = 364115444874638230L;
            {
                this.add(string);
            }
        };
    }

    public static String listToCommaString(List<String> list) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            b.append(list.get(i));
            if (i >= list.size() - 1) continue;
            b.append(",");
        }
        return b.toString();
    }

    public static long lifeToSeconds(String string) {
        if (string.equals("0") || string.equals("")) {
            return 0L;
        }
        String[] lifeMatch = new String[]{"d", "h", "m", "s"};
        int[] lifeInterval = new int[]{86400, 3600, 60, 1};
        long seconds = 0L;
        for (int i = 0; i < lifeMatch.length; ++i) {
            Matcher matcher = Pattern.compile("([0-9]*)" + lifeMatch[i]).matcher(string);
            while (matcher.find()) {
                seconds += (long)(Integer.parseInt(matcher.group(1)) * lifeInterval[i]);
            }
        }
        return seconds;
    }

    public static float roundFloat(float value, int scale) {
        return new BigDecimal(value).setScale(scale, RoundingMode.HALF_UP).floatValue();
    }

    public static double roundDouble(double value, int scale) {
        return new BigDecimal(value).setScale(scale, RoundingMode.HALF_UP).doubleValue();
    }

    public static int floor(double value) {
        int rounded = (int)value;
        return value < (double)rounded ? rounded - 1 : rounded;
    }

    public static boolean isHoneyBlock(Block block) {
        if (MinecraftVersion.getCurrentVersion().isAtLeast(MinecraftVersion.BEE_UPDATE)) {
            return false;
        }
        return block.getType() == XMaterial.HONEY_BLOCK.parseMaterial();
    }

    static {
        if (VersionUtil.isBountifulUpdate()) {
            INSTANT_BREAK.add(XMaterial.COMPARATOR.parseMaterial());
            INSTANT_BREAK.add(XMaterial.REPEATER.parseMaterial());
            INSTANT_BREAK.add(XMaterial.TORCH.parseMaterial());
            INSTANT_BREAK.add(XMaterial.REDSTONE_TORCH.parseMaterial());
            INSTANT_BREAK.add(XMaterial.REDSTONE_WIRE.parseMaterial());
            INSTANT_BREAK.add(XMaterial.TRIPWIRE.parseMaterial());
            INSTANT_BREAK.add(XMaterial.TRIPWIRE_HOOK.parseMaterial());
            INSTANT_BREAK.add(XMaterial.FIRE.parseMaterial());
            INSTANT_BREAK.add(XMaterial.FLOWER_POT.parseMaterial());
            INSTANT_BREAK.add(XMaterial.TNT.parseMaterial());
            INSTANT_BREAK.add(XMaterial.SLIME_BLOCK.parseMaterial());
            INSTANT_BREAK.add(XMaterial.CARROT.parseMaterial());
            INSTANT_BREAK.add(XMaterial.DEAD_BUSH.parseMaterial());
            INSTANT_BREAK.add(XMaterial.GRASS.parseMaterial());
            INSTANT_BREAK.add(XMaterial.TALL_GRASS.parseMaterial());
            INSTANT_BREAK.add(XMaterial.LILY_PAD.parseMaterial());
            INSTANT_BREAK.add(XMaterial.MELON_STEM.parseMaterial());
            INSTANT_BREAK.add(XMaterial.MELON_STEM.parseMaterial());
            INSTANT_BREAK.add(XMaterial.BROWN_MUSHROOM.parseMaterial());
            INSTANT_BREAK.add(XMaterial.RED_MUSHROOM.parseMaterial());
            INSTANT_BREAK.add(XMaterial.NETHER_WART.parseMaterial());
            INSTANT_BREAK.add(XMaterial.POTATO.parseMaterial());
            INSTANT_BREAK.add(XMaterial.PUMPKIN_STEM.parseMaterial());
            INSTANT_BREAK.add(XMaterial.PUMPKIN_STEM.parseMaterial());
            INSTANT_BREAK.add(XMaterial.OAK_SAPLING.parseMaterial());
            INSTANT_BREAK.add(XMaterial.SUGAR_CANE.parseMaterial());
            INSTANT_BREAK.add(XMaterial.WHEAT.parseMaterial());
            FOOD.add(XMaterial.APPLE.parseMaterial());
            FOOD.add(XMaterial.BAKED_POTATO.parseMaterial());
            FOOD.add(XMaterial.BREAD.parseMaterial());
            FOOD.add(XMaterial.CAKE.parseMaterial());
            FOOD.add(XMaterial.CARROT.parseMaterial());
            FOOD.add(XMaterial.COOKED_CHICKEN.parseMaterial());
            FOOD.add(XMaterial.COOKED_COD.parseMaterial());
            FOOD.add(XMaterial.COD.parseMaterial());
            FOOD.add(XMaterial.COOKED_MUTTON.parseMaterial());
            FOOD.add(XMaterial.COOKED_PORKCHOP.parseMaterial());
            FOOD.add(XMaterial.COOKED_RABBIT.parseMaterial());
            FOOD.add(XMaterial.COOKIE.parseMaterial());
            FOOD.add(XMaterial.GOLDEN_APPLE.parseMaterial());
            FOOD.add(XMaterial.GOLDEN_CARROT.parseMaterial());
            FOOD.add(XMaterial.GLISTERING_MELON_SLICE.parseMaterial());
            FOOD.add(XMaterial.MUSHROOM_STEM.parseMaterial());
            FOOD.add(XMaterial.POISONOUS_POTATO.parseMaterial());
            FOOD.add(XMaterial.POTATO.parseMaterial());
            FOOD.add(XMaterial.PUMPKIN_PIE.parseMaterial());
            FOOD.add(XMaterial.RABBIT_STEW.parseMaterial());
            FOOD.add(XMaterial.COOKED_BEEF.parseMaterial());
            FOOD.add(XMaterial.BEEF.parseMaterial());
            FOOD.add(XMaterial.COOKED_CHICKEN.parseMaterial());
            FOOD.add(XMaterial.CHICKEN.parseMaterial());
            FOOD.add(XMaterial.MUTTON.parseMaterial());
            FOOD.add(XMaterial.PORKCHOP.parseMaterial());
            FOOD.add(XMaterial.RABBIT.parseMaterial());
            FOOD.add(XMaterial.COOKED_RABBIT.parseMaterial());
            FOOD.add(XMaterial.ROTTEN_FLESH.parseMaterial());
            FOOD.add(XMaterial.SPIDER_EYE.parseMaterial());
            COMBO.put(XMaterial.SHEARS.parseMaterial(), XMaterial.WHITE_WOOL.parseMaterial());
            COMBO.put(XMaterial.IRON_SWORD.parseMaterial(), XMaterial.COBWEB.parseMaterial());
            COMBO.put(XMaterial.DIAMOND_SWORD.parseMaterial(), XMaterial.COBWEB.parseMaterial());
            COMBO.put(XMaterial.STONE_SWORD.parseMaterial(), XMaterial.COBWEB.parseMaterial());
            COMBO.put(XMaterial.WOODEN_SWORD.parseMaterial(), XMaterial.COBWEB.parseMaterial());
            CLIMBABLE.add(XMaterial.VINE.parseMaterial());
            CLIMBABLE.add(XMaterial.LADDER.parseMaterial());
            CLIMBABLE.add(XMaterial.WATER.parseMaterial());
        } else {
            MinecraftVersion currentVersion = MinecraftVersion.getCurrentVersion();
            INSTANT_BREAK.add(XMaterial.COMPARATOR.parseMaterial());
            INSTANT_BREAK.add(XMaterial.REPEATER.parseMaterial());
            INSTANT_BREAK.add(XMaterial.TORCH.parseMaterial());
            INSTANT_BREAK.add(XMaterial.REDSTONE_TORCH.parseMaterial());
            INSTANT_BREAK.add(XMaterial.REDSTONE_WIRE.parseMaterial());
            INSTANT_BREAK.add(XMaterial.TRIPWIRE.parseMaterial());
            INSTANT_BREAK.add(XMaterial.TRIPWIRE_HOOK.parseMaterial());
            INSTANT_BREAK.add(XMaterial.FIRE.parseMaterial());
            INSTANT_BREAK.add(XMaterial.FLOWER_POT.parseMaterial());
            INSTANT_BREAK.add(XMaterial.INFESTED_CHISELED_STONE_BRICKS.parseMaterial());
            INSTANT_BREAK.add(XMaterial.INFESTED_COBBLESTONE.parseMaterial());
            INSTANT_BREAK.add(XMaterial.INFESTED_CRACKED_STONE_BRICKS.parseMaterial());
            INSTANT_BREAK.add(XMaterial.INFESTED_MOSSY_STONE_BRICKS.parseMaterial());
            INSTANT_BREAK.add(XMaterial.INFESTED_STONE.parseMaterial());
            INSTANT_BREAK.add(XMaterial.INFESTED_STONE_BRICKS.parseMaterial());
            INSTANT_BREAK.add(XMaterial.TNT.parseMaterial());
            INSTANT_BREAK.add(XMaterial.SLIME_BLOCK.parseMaterial());
            INSTANT_BREAK.add(XMaterial.CARROTS.parseMaterial());
            INSTANT_BREAK.add(XMaterial.DEAD_BUSH.parseMaterial());
            INSTANT_BREAK.add(XMaterial.FERN.parseMaterial());
            INSTANT_BREAK.add(XMaterial.LARGE_FERN.parseMaterial());
            INSTANT_BREAK.add(XMaterial.CHORUS_FLOWER.parseMaterial());
            INSTANT_BREAK.add(XMaterial.SUNFLOWER.parseMaterial());
            INSTANT_BREAK.add(XMaterial.LILY_PAD.parseMaterial());
            INSTANT_BREAK.add(XMaterial.MELON_STEM.parseMaterial());
            INSTANT_BREAK.add(XMaterial.ATTACHED_MELON_STEM.parseMaterial());
            INSTANT_BREAK.add(XMaterial.BROWN_MUSHROOM.parseMaterial());
            INSTANT_BREAK.add(XMaterial.RED_MUSHROOM.parseMaterial());
            INSTANT_BREAK.add(XMaterial.NETHER_WART.parseMaterial());
            INSTANT_BREAK.add(XMaterial.POTATOES.parseMaterial());
            INSTANT_BREAK.add(XMaterial.PUMPKIN_STEM.parseMaterial());
            INSTANT_BREAK.add(XMaterial.ATTACHED_PUMPKIN_STEM.parseMaterial());
            INSTANT_BREAK.add(XMaterial.ACACIA_SAPLING.parseMaterial());
            INSTANT_BREAK.add(XMaterial.BIRCH_SAPLING.parseMaterial());
            INSTANT_BREAK.add(XMaterial.DARK_OAK_SAPLING.parseMaterial());
            INSTANT_BREAK.add(XMaterial.JUNGLE_SAPLING.parseMaterial());
            INSTANT_BREAK.add(XMaterial.OAK_SAPLING.parseMaterial());
            INSTANT_BREAK.add(XMaterial.SPRUCE_SAPLING.parseMaterial());
            INSTANT_BREAK.add(XMaterial.SUGAR_CANE.parseMaterial());
            INSTANT_BREAK.add(XMaterial.TALL_GRASS.parseMaterial());
            INSTANT_BREAK.add(XMaterial.TALL_SEAGRASS.parseMaterial());
            INSTANT_BREAK.add(XMaterial.WHEAT.parseMaterial());
            if (currentVersion.isAtLeast(MinecraftVersion.VILLAGE_UPDATE)) {
                INSTANT_BREAK.add(XMaterial.BAMBOO_SAPLING.parseMaterial());
                INSTANT_BREAK.add(XMaterial.CORNFLOWER.parseMaterial());
            }
            if (currentVersion.isAtLeast(MinecraftVersion.BEE_UPDATE)) {
                INSTANT_BREAK.add(XMaterial.HONEY_BLOCK.parseMaterial());
            }
            FOOD.add(XMaterial.APPLE.parseMaterial());
            FOOD.add(XMaterial.BAKED_POTATO.parseMaterial());
            FOOD.add(XMaterial.BEETROOT.parseMaterial());
            FOOD.add(XMaterial.BEETROOT_SOUP.parseMaterial());
            FOOD.add(XMaterial.BREAD.parseMaterial());
            FOOD.add(XMaterial.CAKE.parseMaterial());
            FOOD.add(XMaterial.CARROT.parseMaterial());
            FOOD.add(XMaterial.CHORUS_FRUIT.parseMaterial());
            FOOD.add(XMaterial.COOKED_BEEF.parseMaterial());
            FOOD.add(XMaterial.COOKED_CHICKEN.parseMaterial());
            FOOD.add(XMaterial.COOKED_COD.parseMaterial());
            FOOD.add(XMaterial.COOKED_MUTTON.parseMaterial());
            FOOD.add(XMaterial.COOKED_PORKCHOP.parseMaterial());
            FOOD.add(XMaterial.COOKED_RABBIT.parseMaterial());
            FOOD.add(XMaterial.COOKED_SALMON.parseMaterial());
            FOOD.add(XMaterial.COOKIE.parseMaterial());
            FOOD.add(XMaterial.DRIED_KELP.parseMaterial());
            FOOD.add(XMaterial.ENCHANTED_GOLDEN_APPLE.parseMaterial());
            FOOD.add(XMaterial.GOLDEN_APPLE.parseMaterial());
            FOOD.add(XMaterial.GOLDEN_CARROT.parseMaterial());
            FOOD.add(XMaterial.MELON_SLICE.parseMaterial());
            FOOD.add(XMaterial.MUSHROOM_STEW.parseMaterial());
            FOOD.add(XMaterial.POISONOUS_POTATO.parseMaterial());
            FOOD.add(XMaterial.POTATO.parseMaterial());
            FOOD.add(XMaterial.PUFFERFISH.parseMaterial());
            FOOD.add(XMaterial.PUMPKIN_PIE.parseMaterial());
            FOOD.add(XMaterial.RABBIT_STEW.parseMaterial());
            FOOD.add(XMaterial.BEEF.parseMaterial());
            FOOD.add(XMaterial.CHICKEN.parseMaterial());
            FOOD.add(XMaterial.COD.parseMaterial());
            FOOD.add(XMaterial.MUTTON.parseMaterial());
            FOOD.add(XMaterial.PORKCHOP.parseMaterial());
            FOOD.add(XMaterial.RABBIT.parseMaterial());
            FOOD.add(XMaterial.SALMON.parseMaterial());
            FOOD.add(XMaterial.ROTTEN_FLESH.parseMaterial());
            FOOD.add(XMaterial.SPIDER_EYE.parseMaterial());
            FOOD.add(XMaterial.TROPICAL_FISH.parseMaterial());
            if (currentVersion.isAtLeast(MinecraftVersion.VILLAGE_UPDATE)) {
                FOOD.add(XMaterial.SUSPICIOUS_STEW.parseMaterial());
                FOOD.add(XMaterial.SWEET_BERRIES.parseMaterial());
            }
            if (currentVersion.isAtLeast(MinecraftVersion.BEE_UPDATE)) {
                FOOD.add(XMaterial.HONEY_BOTTLE.parseMaterial());
            }
            COMBO.put(XMaterial.SHEARS.parseMaterial(), XMaterial.BLACK_WOOL.parseMaterial());
            COMBO.put(XMaterial.SHEARS.parseMaterial(), XMaterial.BLUE_WOOL.parseMaterial());
            COMBO.put(XMaterial.SHEARS.parseMaterial(), XMaterial.BROWN_WOOL.parseMaterial());
            COMBO.put(XMaterial.SHEARS.parseMaterial(), XMaterial.CYAN_WOOL.parseMaterial());
            COMBO.put(XMaterial.SHEARS.parseMaterial(), XMaterial.GRAY_WOOL.parseMaterial());
            COMBO.put(XMaterial.SHEARS.parseMaterial(), XMaterial.GREEN_WOOL.parseMaterial());
            COMBO.put(XMaterial.SHEARS.parseMaterial(), XMaterial.LIGHT_BLUE_WOOL.parseMaterial());
            COMBO.put(XMaterial.SHEARS.parseMaterial(), XMaterial.LIGHT_GRAY_WOOL.parseMaterial());
            COMBO.put(XMaterial.SHEARS.parseMaterial(), XMaterial.LIME_WOOL.parseMaterial());
            COMBO.put(XMaterial.SHEARS.parseMaterial(), XMaterial.MAGENTA_WOOL.parseMaterial());
            COMBO.put(XMaterial.SHEARS.parseMaterial(), XMaterial.MAGENTA_WOOL.parseMaterial());
            COMBO.put(XMaterial.SHEARS.parseMaterial(), XMaterial.ORANGE_WOOL.parseMaterial());
            COMBO.put(XMaterial.SHEARS.parseMaterial(), XMaterial.PINK_WOOL.parseMaterial());
            COMBO.put(XMaterial.SHEARS.parseMaterial(), XMaterial.PURPLE_WOOL.parseMaterial());
            COMBO.put(XMaterial.SHEARS.parseMaterial(), XMaterial.RED_WOOL.parseMaterial());
            COMBO.put(XMaterial.SHEARS.parseMaterial(), XMaterial.WHITE_WOOL.parseMaterial());
            COMBO.put(XMaterial.SHEARS.parseMaterial(), XMaterial.YELLOW_WOOL.parseMaterial());
            COMBO.put(XMaterial.IRON_SWORD.parseMaterial(), XMaterial.COBWEB.parseMaterial());
            COMBO.put(XMaterial.DIAMOND_SWORD.parseMaterial(), XMaterial.COBWEB.parseMaterial());
            COMBO.put(XMaterial.STONE_SWORD.parseMaterial(), XMaterial.COBWEB.parseMaterial());
            COMBO.put(XMaterial.WOODEN_SWORD.parseMaterial(), XMaterial.COBWEB.parseMaterial());
            CLIMBABLE.add(XMaterial.VINE.parseMaterial());
            CLIMBABLE.add(XMaterial.LADDER.parseMaterial());
            CLIMBABLE.add(XMaterial.WATER.parseMaterial());
            if (currentVersion.isAtLeast(MinecraftVersion.VILLAGE_UPDATE)) {
                CLIMBABLE.add(XMaterial.SCAFFOLDING.parseMaterial());
                CLIMBABLE.add(XMaterial.SWEET_BERRY_BUSH.parseMaterial());
            }
            if (currentVersion.isAtLeast(MinecraftVersion.NETHER_UPDATE)) {
                CLIMBABLE.add(XMaterial.TWISTING_VINES.parseMaterial());
                CLIMBABLE.add(XMaterial.TWISTING_VINES_PLANT.parseMaterial());
                CLIMBABLE.add(XMaterial.WEEPING_VINES.parseMaterial());
                CLIMBABLE.add(XMaterial.WEEPING_VINES_PLANT.parseMaterial());
            }
        }
    }
}

