/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.util;

import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.util.MinecraftVersion;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class VersionUtil {
    public static final MinecraftVersion CURRENT_VERSION;
    private static final List<String> SUPPORTED_VERSIONS;

    public static String getVersion() {
        return Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
    }

    public static boolean isSupported() {
        for (String versionId : SUPPORTED_VERSIONS) {
            if (!VersionUtil.getVersion().startsWith(versionId)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOfVersion(String versionId) {
        return VersionUtil.getVersion().startsWith(versionId);
    }

    public static boolean isBountifulUpdate() {
        return VersionUtil.isOfVersion("v1_8");
    }

    public static boolean isFlying(Player player) {
        if (VersionUtil.isBountifulUpdate()) {
            return player.isFlying();
        }
        return player.isFlying() || player.isGliding() || player.hasPotionEffect(PotionEffectType.LEVITATION) || AntiCheatReloaded.getManager().getBackend().justLevitated(player);
    }

    public static boolean isSlowFalling(Player player) {
        if (!CURRENT_VERSION.isAtLeast(MinecraftVersion.AQUATIC_UPDATE)) {
            return false;
        }
        return player.hasPotionEffect(PotionEffectType.SLOW_FALLING);
    }

    public static boolean isFrostWalk(Player player) {
        if (player.getInventory().getBoots() == null || VersionUtil.isBountifulUpdate()) {
            return false;
        }
        return player.getInventory().getBoots().containsEnchantment(Enchantment.FROST_WALKER);
    }

    public static ItemStack getItemInHand(Player player) {
        if (VersionUtil.isBountifulUpdate()) {
            return player.getItemInHand();
        }
        return player.getInventory().getItemInMainHand();
    }

    public static int getPlayerPing(Player player) {
        try {
            Object entityPlayer = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
            int ping = (Integer)entityPlayer.getClass().getField("ping").get(entityPlayer);
            return ping;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static Block getTargetBlock(Player player, int distance) {
        if (!CURRENT_VERSION.isAtLeast(MinecraftVersion.AQUATIC_UPDATE)) {
            return player.getTargetBlock((Set)null, distance);
        }
        return player.getTargetBlockExact(distance);
    }

    public static boolean isGliding(Player player) {
        if (VersionUtil.isBountifulUpdate()) {
            return false;
        }
        return player.isGliding();
    }

    public static boolean isLevitationEffect(PotionEffect effect) {
        if (VersionUtil.isBountifulUpdate()) {
            return false;
        }
        return effect.getType().equals((Object)PotionEffectType.LEVITATION);
    }

    public static int getPotionLevel(Player player, PotionEffectType type) {
        if (VersionUtil.isBountifulUpdate()) {
            for (PotionEffect effect : player.getActivePotionEffects()) {
                if (!effect.getType().equals((Object)type)) continue;
                return effect.getAmplifier() + 1;
            }
            return 0;
        }
        if (player.hasPotionEffect(type)) {
            return player.getPotionEffect(type).getAmplifier() + 1;
        }
        return 0;
    }

    public static boolean isSwimming(Player player) {
        if (!CURRENT_VERSION.isAtLeast(MinecraftVersion.AQUATIC_UPDATE)) {
            return false;
        }
        return player.isSwimming();
    }

    static {
        SUPPORTED_VERSIONS = Arrays.asList("v1_16", "v1_15", "v1_14", "v1_13", "v1_12", "v1_8_R3");
        CURRENT_VERSION = MinecraftVersion.getCurrentVersion();
    }
}

