/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.util.enterprise;

import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.check.CheckType;
import com.rammelkast.anticheatreloaded.util.User;
import com.rammelkast.anticheatreloaded.util.Utilities;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class Database {
    private static final String EVENTS_TABLE = "logs";
    private String sqlLogEvent;
    private String sqlCleanEvents;
    private String sqlCreateEvents;
    private DatabaseType type;
    private String hostname;
    private int port;
    private String username;
    private String password;
    private String prefix;
    private String schema;
    private String serverName;
    private long logInterval;
    private long logLife;
    private boolean syncLevels;
    private long syncInterval;
    private Connection connection;
    private PreparedStatement eventBatch;
    private BukkitTask eventTask;
    private BukkitTask syncTask;

    public Database(DatabaseType type, String hostname, int port, String username, String password, String prefix, String schema, String serverName, String logInterval, String logLife, boolean syncLevels, String syncInterval) {
        this.type = type;
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.password = password;
        this.prefix = prefix;
        this.schema = schema;
        this.serverName = serverName;
        this.logInterval = Utilities.lifeToSeconds(logInterval);
        this.logLife = Utilities.lifeToSeconds(logLife);
        this.syncLevels = syncLevels;
        this.syncInterval = Utilities.lifeToSeconds(syncInterval);
        this.sqlLogEvent = "INSERT INTO " + prefix + EVENTS_TABLE + " (server, user, check_type) VALUES (?, ?, ?)";
        this.sqlCleanEvents = "DELETE FROM " + prefix + EVENTS_TABLE + " WHERE time < (CURRENT_TIMESTAMP - INTERVAL ? SECOND)";
        this.sqlCreateEvents = "CREATE TABLE IF NOT EXISTS " + prefix + EVENTS_TABLE + "(  `id` INT NOT NULL AUTO_INCREMENT,  `server` VARCHAR(45) NOT NULL,  `time` TIMESTAMP NOT NULL DEFAULT NOW(),  `user` VARCHAR(45) NOT NULL,  `check_type` VARCHAR(45) NOT NULL,  PRIMARY KEY (`id`));";
    }

    public DatabaseType getType() {
        return this.type;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSchema() {
        return this.schema;
    }

    public void connect() {
        String url = "jdbc:" + this.type.toString().toLowerCase() + "://" + this.hostname + ":" + this.port + "/" + this.schema;
        try {
            this.connection = DriverManager.getConnection(url, this.username, this.password);
            this.eventBatch = this.connection.prepareStatement(this.sqlLogEvent);
            this.connection.prepareStatement(this.sqlCreateEvents).executeUpdate();
            this.connection.setAutoCommit(false);
            if (this.logInterval != 0L) {
                this.eventTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)AntiCheatReloaded.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        Database.this.flushEvents();
                    }
                }, this.logInterval * 20L, this.logInterval * 20L);
            }
            if (this.syncLevels && this.syncInterval != 0L) {
                this.syncTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)AntiCheatReloaded.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        Database.this.syncUsers();
                    }
                }, this.syncInterval * 20L, this.syncInterval * 20L);
            }
            AntiCheatReloaded.getPlugin().verboseLog("Connected to the database.");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
        if (this.eventTask != null) {
            this.eventTask.cancel();
        }
        if (this.syncTask != null) {
            this.syncTask.cancel();
        }
        this.flushEvents();
        try {
            this.eventBatch.close();
            this.connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void logEvent(User user, CheckType checkType) {
        try {
            this.eventBatch.setString(1, this.serverName);
            this.eventBatch.setString(2, user.getUUID().toString());
            this.eventBatch.setString(3, checkType.toString());
            this.eventBatch.addBatch();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void flushEvents() {
        try {
            this.eventBatch.executeBatch();
            this.connection.commit();
            this.eventBatch = this.connection.prepareStatement(this.sqlLogEvent);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void cleanEvents() {
        if (this.logLife != 0L) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)AntiCheatReloaded.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    try {
                        PreparedStatement statement = Database.this.connection.prepareStatement(Database.this.sqlCleanEvents);
                        statement.setLong(1, Database.this.logLife);
                        statement.executeUpdate();
                        Database.this.connection.commit();
                        AntiCheatReloaded.getPlugin().verboseLog("Cleaned " + statement.getUpdateCount() + " old events from the database");
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private void syncUsers() {
        for (User user : AntiCheatReloaded.getManager().getUserManager().getUsers()) {
            AntiCheatReloaded.getManager().getConfiguration().getLevels().updateLevelToUser(user);
        }
    }

    public static enum DatabaseType {
        MySQL;

    }
}

