/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.adventure.text.format;

import java.util.Objects;
import me.lucko.luckperms.lib.adventure.text.format.Style;
import me.lucko.luckperms.lib.adventure.text.format.StyleBuilderApplicable;
import me.lucko.luckperms.lib.adventure.text.format.TextDecorationAndState;
import me.lucko.luckperms.lib.adventure.text.format.TextDecorationAndStateImpl;
import me.lucko.luckperms.lib.adventure.text.format.TextFormat;
import me.lucko.luckperms.lib.adventure.util.Index;
import me.lucko.luckperms.lib.adventure.util.TriState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum TextDecoration implements StyleBuilderApplicable,
TextFormat
{
    OBFUSCATED("obfuscated"),
    BOLD("bold"),
    STRIKETHROUGH("strikethrough"),
    UNDERLINED("underlined"),
    ITALIC("italic");

    public static final Index<String, TextDecoration> NAMES;
    private final String name;

    private TextDecoration(String name) {
        this.name = name;
    }

    @NotNull
    public final TextDecorationAndState as(boolean state) {
        return this.as(State.byBoolean(state));
    }

    @NotNull
    public final TextDecorationAndState as(@NotNull State state) {
        return new TextDecorationAndStateImpl(this, state);
    }

    @Override
    public void styleApply(@NotNull Style.Builder style) {
        style.decorate(this);
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    static {
        NAMES = Index.create(TextDecoration.class, constant -> constant.name);
    }

    public static enum State {
        NOT_SET("not_set"),
        FALSE("false"),
        TRUE("true");

        private final String name;

        private State(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public static State byBoolean(boolean flag) {
            return flag ? TRUE : FALSE;
        }

        @NotNull
        public static State byBoolean(@Nullable Boolean flag) {
            return flag == null ? NOT_SET : State.byBoolean((boolean)flag);
        }

        @NotNull
        public static State byTriState(@NotNull TriState flag) {
            Objects.requireNonNull(flag);
            switch (flag) {
                case TRUE: {
                    return TRUE;
                }
                case FALSE: {
                    return FALSE;
                }
                case NOT_SET: {
                    return NOT_SET;
                }
            }
            throw new IllegalArgumentException("Unable to turn TriState: " + (Object)((Object)flag) + " into a TextDecoration.State");
        }
    }
}

