/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.api.beta;

import me.filoghost.holographicdisplays.api.beta.internal.HolographicDisplaysAPIProvider;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Position {
    @NotNull
    public static Position of(@NotNull World world, double x, double y, double z) {
        return HolographicDisplaysAPIProvider.getImplementation().createPosition(world, x, y, z);
    }

    @NotNull
    public static Position of(@NotNull String worldName, double x, double y, double z) {
        return HolographicDisplaysAPIProvider.getImplementation().createPosition(worldName, x, y, z);
    }

    @NotNull
    public static Position of(@NotNull Location location) {
        return HolographicDisplaysAPIProvider.getImplementation().getPosition(location);
    }

    @NotNull
    public static Position of(@NotNull Entity entity) {
        return HolographicDisplaysAPIProvider.getImplementation().getPosition(entity);
    }

    @NotNull
    public static Position of(@NotNull Block block) {
        return HolographicDisplaysAPIProvider.getImplementation().getPosition(block);
    }

    @NotNull
    public String getWorldName();

    public double getX();

    public double getY();

    public double getZ();

    @Nullable
    public World getWorldIfLoaded();

    public boolean isInSameWorld(@NotNull Position var1);

    public boolean isInSameWorld(@NotNull Location var1);

    public boolean isInSameWorld(@NotNull Entity var1);

    public boolean isInWorld(@Nullable World var1);

    public boolean isInWorld(@Nullable String var1);

    public int getBlockX();

    public int getBlockY();

    public int getBlockZ();

    @NotNull
    public Position add(double var1, double var3, double var5);

    @NotNull
    public Position subtract(double var1, double var3, double var5);

    public double distance(@NotNull Position var1);

    public double distance(@NotNull Location var1);

    public double distance(@NotNull Entity var1);

    public double distanceSquared(@NotNull Position var1);

    public double distanceSquared(@NotNull Location var1);

    public double distanceSquared(@NotNull Entity var1);

    @NotNull
    public Location toLocation();

    @NotNull
    public Vector toVector();
}

