/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.nms.v1_10_R1;

import com.google.common.base.Optional;
import me.filoghost.holographicdisplays.nms.v1_10_R1.DataWatcherKey;
import me.filoghost.holographicdisplays.nms.v1_10_R1.PacketByteBuffer;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Strings;
import org.bukkit.craftbukkit.v1_10_R1.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

abstract class DataWatcherPacketBuilder<T> {
    private final PacketByteBuffer packetByteBuffer;

    DataWatcherPacketBuilder(PacketByteBuffer packetByteBuffer) {
        this.packetByteBuffer = packetByteBuffer;
    }

    DataWatcherPacketBuilder<T> setInvisible() {
        this.packetByteBuffer.writeDataWatcherEntry(DataWatcherKey.ENTITY_STATUS, (byte)32);
        return this;
    }

    DataWatcherPacketBuilder<T> setArmorStandMarker() {
        this.setInvisible();
        this.packetByteBuffer.writeDataWatcherEntry(DataWatcherKey.ARMOR_STAND_STATUS, (byte)27);
        return this;
    }

    DataWatcherPacketBuilder<T> setCustomName(String customName) {
        this.packetByteBuffer.writeDataWatcherEntry(DataWatcherKey.CUSTOM_NAME, Strings.truncate(customName, 300));
        this.packetByteBuffer.writeDataWatcherEntry(DataWatcherKey.CUSTOM_NAME_VISIBILITY, !Strings.isEmpty(customName));
        return this;
    }

    DataWatcherPacketBuilder<T> setItemStack(ItemStack itemStack) {
        this.packetByteBuffer.writeDataWatcherEntry(DataWatcherKey.ITEM_STACK, Optional.fromNullable((Object)CraftItemStack.asNMSCopy((ItemStack)itemStack)));
        return this;
    }

    DataWatcherPacketBuilder<T> setSlimeSmall() {
        this.packetByteBuffer.writeDataWatcherEntry(DataWatcherKey.SLIME_SIZE, 1);
        return this;
    }

    T build() {
        this.packetByteBuffer.writeDataWatcherEntriesEnd();
        return this.createPacket(this.packetByteBuffer);
    }

    abstract T createPacket(PacketByteBuffer var1);
}

