/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.nms.v1_12_R1;

import me.filoghost.holographicdisplays.common.PositionCoordinates;
import me.filoghost.holographicdisplays.nms.common.EntityID;
import me.filoghost.holographicdisplays.nms.v1_12_R1.DataWatcherPacketBuilder;
import me.filoghost.holographicdisplays.nms.v1_12_R1.PacketByteBuffer;
import me.filoghost.holographicdisplays.nms.v1_12_R1.VersionNMSPacket;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.reflection.ReflectField;
import net.minecraft.server.v1_12_R1.DataWatcher;
import net.minecraft.server.v1_12_R1.Packet;
import net.minecraft.server.v1_12_R1.PacketDataSerializer;
import net.minecraft.server.v1_12_R1.PacketPlayOutSpawnEntityLiving;

class EntityLivingSpawnNMSPacket
extends VersionNMSPacket {
    private static final ReflectField<DataWatcher> DATA_WATCHER_FIELD = ReflectField.lookup(DataWatcher.class, PacketPlayOutSpawnEntityLiving.class, "m");
    private final Packet<?> rawPacket;

    private EntityLivingSpawnNMSPacket(Packet<?> rawPacket, DataWatcher dataWatcher) {
        this.rawPacket = rawPacket;
        try {
            DATA_WATCHER_FIELD.set(rawPacket, dataWatcher);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    Packet<?> getRawPacket() {
        return this.rawPacket;
    }

    public static DataWatcherPacketBuilder<EntityLivingSpawnNMSPacket> builder(EntityID entityID, int entityTypeID, PositionCoordinates position, double positionOffsetY) {
        PacketByteBuffer packetByteBuffer = PacketByteBuffer.get();
        packetByteBuffer.writeVarInt(entityID.getNumericID());
        packetByteBuffer.writeUUID(entityID.getUUID());
        packetByteBuffer.writeVarInt(entityTypeID);
        packetByteBuffer.writeDouble(position.getX());
        packetByteBuffer.writeDouble(position.getY() + positionOffsetY);
        packetByteBuffer.writeDouble(position.getZ());
        packetByteBuffer.writeByte(0);
        packetByteBuffer.writeByte(0);
        packetByteBuffer.writeByte(0);
        packetByteBuffer.writeShort(0);
        packetByteBuffer.writeShort(0);
        packetByteBuffer.writeShort(0);
        packetByteBuffer.writeDataWatcherEntriesEnd();
        PacketPlayOutSpawnEntityLiving rawPacket = EntityLivingSpawnNMSPacket.writeData(new PacketPlayOutSpawnEntityLiving(), packetByteBuffer);
        return new Builder((Packet)rawPacket, PacketByteBuffer.get());
    }

    private static class Builder
    extends DataWatcherPacketBuilder<EntityLivingSpawnNMSPacket> {
        private final Packet<?> rawPacket;

        private Builder(Packet<?> rawPacket, PacketByteBuffer packetByteBuffer) {
            super(packetByteBuffer);
            this.rawPacket = rawPacket;
        }

        @Override
        EntityLivingSpawnNMSPacket createPacket(PacketByteBuffer packetByteBuffer) {
            return new EntityLivingSpawnNMSPacket(this.rawPacket, new SerializedDataWatcher(packetByteBuffer));
        }
    }

    private static class SerializedDataWatcher
    extends DataWatcher {
        private final byte[] serializedValue;

        SerializedDataWatcher(PacketByteBuffer dataByteBuffer) {
            super(null);
            this.serializedValue = new byte[dataByteBuffer.readableBytes()];
            dataByteBuffer.readBytes(this.serializedValue);
        }

        public void a(PacketDataSerializer packetDataSerializer) {
            packetDataSerializer.writeBytes(this.serializedValue);
        }
    }
}

