/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.nms.v1_17_R1;

import java.lang.reflect.Field;
import me.filoghost.holographicdisplays.nms.common.EntityID;
import me.filoghost.holographicdisplays.nms.common.PacketGroup;
import me.filoghost.holographicdisplays.nms.v1_17_R1.EntityDestroyNMSPacket;
import me.filoghost.holographicdisplays.nms.v1_17_R1.EntityListDestroyNMSPacket;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.logging.Log;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import org.bukkit.craftbukkit.libs.it.unimi.dsi.fastutil.ints.IntList;

class PacketHelper {
    private static final boolean USE_ENTITY_LIST_DESTROY_PACKET = PacketHelper.useEntityListDestroyPacket();

    PacketHelper() {
    }

    static PacketGroup newDestroyPackets(EntityID entityID) {
        if (USE_ENTITY_LIST_DESTROY_PACKET) {
            return new EntityListDestroyNMSPacket(entityID);
        }
        return new EntityDestroyNMSPacket(entityID);
    }

    static PacketGroup newDestroyPackets(EntityID entityID1, EntityID entityID2) {
        if (USE_ENTITY_LIST_DESTROY_PACKET) {
            return new EntityListDestroyNMSPacket(entityID1, entityID2);
        }
        return PacketGroup.of(new EntityDestroyNMSPacket(entityID1), new EntityDestroyNMSPacket(entityID2));
    }

    private static boolean useEntityListDestroyPacket() {
        try {
            for (Field field : PacketPlayOutEntityDestroy.class.getDeclaredFields()) {
                if (field.getType() != IntList.class) continue;
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            Log.warning("Could not detect PacketPlayOutEntityDestroy details, error can be ignored if on Minecraft 1.17.1+", t);
            return true;
        }
    }
}

