/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin;

import com.gmail.filoghost.holographicdisplays.api.internal.HologramsAPIProvider;
import java.util.concurrent.TimeUnit;
import me.filoghost.holographicdisplays.api.beta.internal.HolographicDisplaysAPIProvider;
import me.filoghost.holographicdisplays.nms.common.NMSManager;
import me.filoghost.holographicdisplays.plugin.api.current.APIHologramManager;
import me.filoghost.holographicdisplays.plugin.api.current.DefaultHolographicDisplaysAPIProvider;
import me.filoghost.holographicdisplays.plugin.api.v2.V2HologramManager;
import me.filoghost.holographicdisplays.plugin.api.v2.V2HologramsAPIProvider;
import me.filoghost.holographicdisplays.plugin.bridge.bungeecord.BungeeServerTracker;
import me.filoghost.holographicdisplays.plugin.bridge.placeholderapi.PlaceholderAPIHook;
import me.filoghost.holographicdisplays.plugin.commands.HologramCommandManager;
import me.filoghost.holographicdisplays.plugin.config.ConfigManager;
import me.filoghost.holographicdisplays.plugin.config.HologramDatabase;
import me.filoghost.holographicdisplays.plugin.config.Settings;
import me.filoghost.holographicdisplays.plugin.config.upgrade.AnimationsLegacyUpgrade;
import me.filoghost.holographicdisplays.plugin.config.upgrade.DatabaseLegacyUpgrade;
import me.filoghost.holographicdisplays.plugin.config.upgrade.SymbolsLegacyUpgrade;
import me.filoghost.holographicdisplays.plugin.hologram.base.BaseHologram;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.LineTrackerManager;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologramManager;
import me.filoghost.holographicdisplays.plugin.internal.placeholder.AnimationPlaceholderFactory;
import me.filoghost.holographicdisplays.plugin.internal.placeholder.DefaultPlaceholders;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.FCommonsPlugin;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.FeatureSupport;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.logging.ErrorCollector;
import me.filoghost.holographicdisplays.plugin.lib.metrics.MetricsLite;
import me.filoghost.holographicdisplays.plugin.listener.ChunkListener;
import me.filoghost.holographicdisplays.plugin.listener.LineClickListener;
import me.filoghost.holographicdisplays.plugin.listener.PlayerListener;
import me.filoghost.holographicdisplays.plugin.listener.UpdateNotificationListener;
import me.filoghost.holographicdisplays.plugin.log.PrintableErrorCollector;
import me.filoghost.holographicdisplays.plugin.placeholder.registry.PlaceholderRegistry;
import me.filoghost.holographicdisplays.plugin.placeholder.tracking.ActivePlaceholderTracker;
import me.filoghost.holographicdisplays.plugin.tick.TickClock;
import me.filoghost.holographicdisplays.plugin.tick.TickingTask;
import me.filoghost.holographicdisplays.plugin.util.NMSVersion;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class HolographicDisplays
extends FCommonsPlugin {
    private static HolographicDisplays instance;
    private NMSManager nmsManager;
    private ConfigManager configManager;
    private BungeeServerTracker bungeeServerTracker;
    private PlaceholderRegistry placeholderRegistry;
    private LineTrackerManager lineTrackerManager;
    private InternalHologramManager internalHologramManager;
    private APIHologramManager apiHologramManager;
    private V2HologramManager v2HologramManager;

    @Override
    public void onCheckedEnable() throws FCommonsPlugin.PluginEnableException {
        if (instance != null || System.getProperty("HolographicDisplaysLoaded") != null) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[HolographicDisplays] Please do not use /reload or plugin reloaders. Use the command \"/holograms reload\" instead. You will receive no support for doing this operation.");
        }
        System.setProperty("HolographicDisplaysLoaded", "true");
        instance = this;
        if (!FeatureSupport.CHAT_COMPONENTS) {
            throw new FCommonsPlugin.PluginEnableException("Holographic Displays requires the new chat API.", "You are probably running CraftBukkit instead of Spigot.");
        }
        if (this.getCommand("holograms") == null) {
            throw new FCommonsPlugin.PluginEnableException("Holographic Displays was unable to register the command \"holograms\".", "This can be caused by edits to plugin.yml or other plugins.");
        }
        PrintableErrorCollector errorCollector = new PrintableErrorCollector();
        try {
            this.nmsManager = NMSVersion.getCurrent().createNMSManager(errorCollector);
        }
        catch (NMSVersion.UnknownVersionException e) {
            throw new FCommonsPlugin.PluginEnableException(new String[]{"Holographic Displays only supports Spigot from 1.8 to 1.17."});
        }
        catch (NMSVersion.OutdatedVersionException e) {
            throw new FCommonsPlugin.PluginEnableException(new String[]{"Holographic Displays only supports " + e.getMinimumSupportedVersion() + " and above."});
        }
        catch (Throwable t) {
            throw new FCommonsPlugin.PluginEnableException(t, "Couldn't initialize the NMS manager.");
        }
        this.configManager = new ConfigManager(this.getDataFolder().toPath());
        this.bungeeServerTracker = new BungeeServerTracker((Plugin)this);
        this.placeholderRegistry = new PlaceholderRegistry();
        TickClock tickClock = new TickClock();
        ActivePlaceholderTracker placeholderTracker = new ActivePlaceholderTracker(this.placeholderRegistry, tickClock);
        LineClickListener lineClickListener = new LineClickListener();
        this.lineTrackerManager = new LineTrackerManager(this.nmsManager, placeholderTracker, lineClickListener);
        this.internalHologramManager = new InternalHologramManager(this.lineTrackerManager);
        this.apiHologramManager = new APIHologramManager(this.lineTrackerManager);
        this.v2HologramManager = new V2HologramManager(this.lineTrackerManager);
        new SymbolsLegacyUpgrade(this.configManager, errorCollector).tryRun();
        new AnimationsLegacyUpgrade(this.configManager, errorCollector).tryRun();
        new DatabaseLegacyUpgrade(this.configManager, errorCollector).tryRun();
        this.load(errorCollector);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.nmsManager.injectPacketListener(player, lineClickListener);
        }
        new HologramCommandManager(this, this.internalHologramManager, this.configManager).register(this);
        this.registerListener(new PlayerListener(this.nmsManager, this.lineTrackerManager, lineClickListener));
        this.registerListener(new ChunkListener((Plugin)this, this.internalHologramManager, this.apiHologramManager, this.v2HologramManager));
        UpdateNotificationListener updateNotificationListener = new UpdateNotificationListener();
        this.registerListener(updateNotificationListener);
        TickingTask tickingTask = new TickingTask(tickClock, placeholderTracker, this.lineTrackerManager, lineClickListener);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)tickingTask, 0L, 1L);
        updateNotificationListener.runAsyncUpdateCheck(this);
        HolographicDisplaysAPIProvider.setImplementation(new DefaultHolographicDisplaysAPIProvider(this.apiHologramManager, this.placeholderRegistry));
        this.enableLegacyAPI(this.v2HologramManager, this.placeholderRegistry);
        PlaceholderAPIHook.setup();
        int pluginID = 3123;
        new MetricsLite((Plugin)this, pluginID);
        if (errorCollector.hasErrors()) {
            errorCollector.logToConsole();
            Bukkit.getScheduler().runTaskLater((Plugin)this, errorCollector::logSummaryToConsole, 10L);
        }
    }

    private void enableLegacyAPI(V2HologramManager hologramManager, PlaceholderRegistry placeholderRegistry) {
        HologramsAPIProvider.setImplementation(new V2HologramsAPIProvider(hologramManager, placeholderRegistry));
    }

    public void load(ErrorCollector errorCollector) {
        this.internalHologramManager.deleteHolograms();
        this.configManager.reloadStaticReplacements(errorCollector);
        this.configManager.reloadMainSettings(errorCollector);
        AnimationPlaceholderFactory animationPlaceholderFactory = this.configManager.loadAnimations(errorCollector);
        DefaultPlaceholders.resetAndRegister((Plugin)this, this.placeholderRegistry, animationPlaceholderFactory, this.bungeeServerTracker);
        this.bungeeServerTracker.restart(Settings.bungeeRefreshSeconds, TimeUnit.SECONDS);
        HologramDatabase hologramDatabase = this.configManager.loadHologramDatabase(errorCollector);
        hologramDatabase.createHolograms(this.internalHologramManager, errorCollector);
        for (BaseHologram hologram : this.apiHologramManager.getHolograms()) {
            hologram.getLines().updatePositions();
        }
        for (BaseHologram hologram : this.v2HologramManager.getHolograms()) {
            hologram.getLines().updatePositions();
        }
    }

    public void onDisable() {
        if (this.lineTrackerManager != null) {
            this.lineTrackerManager.resetViewersAndSendDestroyPackets();
        }
        if (this.nmsManager != null) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.nmsManager.uninjectPacketListener(player);
            }
        }
    }

    public static HolographicDisplays getInstance() {
        return instance;
    }
}

