/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.api.current;

import me.filoghost.holographicdisplays.api.beta.Position;
import me.filoghost.holographicdisplays.api.beta.hologram.Hologram;
import me.filoghost.holographicdisplays.api.beta.hologram.ResolvePlaceholders;
import me.filoghost.holographicdisplays.plugin.api.current.APIHologramLine;
import me.filoghost.holographicdisplays.plugin.api.current.APIHologramLines;
import me.filoghost.holographicdisplays.plugin.api.current.APIHologramManager;
import me.filoghost.holographicdisplays.plugin.api.current.DefaultVisibilitySettings;
import me.filoghost.holographicdisplays.plugin.hologram.base.BaseHologram;
import me.filoghost.holographicdisplays.plugin.hologram.base.ImmutablePosition;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.LineTrackerManager;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Preconditions;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

class APIHologram
extends BaseHologram
implements Hologram {
    private final APIHologramLines lines;
    private final Plugin plugin;
    private final APIHologramManager hologramManager;
    private final DefaultVisibilitySettings visibilitySettings;
    @NotNull
    private ResolvePlaceholders resolvePlaceholders;

    APIHologram(ImmutablePosition position, Plugin plugin, APIHologramManager hologramManager, LineTrackerManager lineTrackerManager) {
        super(position, lineTrackerManager);
        Preconditions.notNull(plugin, "plugin");
        this.lines = new APIHologramLines(this);
        this.plugin = plugin;
        this.hologramManager = hologramManager;
        this.visibilitySettings = new DefaultVisibilitySettings();
        this.resolvePlaceholders = ResolvePlaceholders.DEFAULT;
    }

    @Override
    @NotNull
    public APIHologramLines getLines() {
        return this.lines;
    }

    @Override
    @NotNull
    public DefaultVisibilitySettings getVisibilitySettings() {
        return this.visibilitySettings;
    }

    @Override
    public void setPosition(@NotNull Position position) {
        super.setPosition(ImmutablePosition.of(position));
    }

    @Override
    @NotNull
    public ResolvePlaceholders getResolvePlaceholders() {
        return this.resolvePlaceholders;
    }

    @Override
    public void setResolvePlaceholders(@NotNull ResolvePlaceholders resolvePlaceholders) {
        Preconditions.notNull((Object)resolvePlaceholders, "resolvePlaceholders");
        this.checkNotDeleted();
        if (this.resolvePlaceholders == resolvePlaceholders) {
            return;
        }
        this.resolvePlaceholders = resolvePlaceholders;
        for (APIHologramLine line : this.lines) {
            line.setChanged();
        }
    }

    @Override
    public Plugin getCreatorPlugin() {
        return this.plugin;
    }

    @Override
    public boolean isVisibleTo(Player player) {
        return this.visibilitySettings.isVisibleTo(player);
    }

    @Override
    public void delete() {
        this.hologramManager.deleteHologram(this);
    }
}

