/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.api.current;

import java.util.Collection;
import me.filoghost.holographicdisplays.api.beta.HolographicDisplaysAPI;
import me.filoghost.holographicdisplays.api.beta.Position;
import me.filoghost.holographicdisplays.api.beta.hologram.Hologram;
import me.filoghost.holographicdisplays.api.beta.placeholder.GlobalPlaceholder;
import me.filoghost.holographicdisplays.api.beta.placeholder.GlobalPlaceholderFactory;
import me.filoghost.holographicdisplays.api.beta.placeholder.GlobalPlaceholderReplacementSupplier;
import me.filoghost.holographicdisplays.api.beta.placeholder.IndividualPlaceholder;
import me.filoghost.holographicdisplays.api.beta.placeholder.IndividualPlaceholderFactory;
import me.filoghost.holographicdisplays.api.beta.placeholder.IndividualPlaceholderReplacementSupplier;
import me.filoghost.holographicdisplays.api.beta.placeholder.RegisteredPlaceholder;
import me.filoghost.holographicdisplays.plugin.api.current.APIHologramManager;
import me.filoghost.holographicdisplays.plugin.hologram.base.ImmutablePosition;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Preconditions;
import me.filoghost.holographicdisplays.plugin.placeholder.registry.PlaceholderRegistry;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

class DefaultHolographicDisplaysAPI
implements HolographicDisplaysAPI {
    private final Plugin plugin;
    private final APIHologramManager apiHologramManager;
    private final PlaceholderRegistry placeholderRegistry;

    DefaultHolographicDisplaysAPI(Plugin plugin, APIHologramManager apiHologramManager, PlaceholderRegistry placeholderRegistry) {
        this.plugin = plugin;
        this.apiHologramManager = apiHologramManager;
        this.placeholderRegistry = placeholderRegistry;
    }

    @Override
    @NotNull
    public Hologram createHologram(@NotNull Location location) {
        Preconditions.notNull(location, "location");
        Preconditions.notNull(location.getWorld(), "location.getWorld()");
        Preconditions.checkMainThread("async hologram creation");
        return this.apiHologramManager.createHologram(ImmutablePosition.of(location), this.plugin);
    }

    @Override
    @NotNull
    public Hologram createHologram(@NotNull Position position) {
        Preconditions.notNull(position, "position");
        Preconditions.notNull(position.getWorldName(), "position.getWorldName()");
        Preconditions.checkMainThread("async hologram creation");
        return this.apiHologramManager.createHologram(ImmutablePosition.of(position), this.plugin);
    }

    @Override
    public void registerGlobalPlaceholder(@NotNull String identifier, int refreshIntervalTicks, @NotNull GlobalPlaceholderReplacementSupplier replacementSupplier) {
        this.checkIdentifier(identifier);
        Preconditions.checkArgument(refreshIntervalTicks >= 0, "refreshIntervalTicks should be positive");
        Preconditions.notNull(replacementSupplier, "replacementSupplier");
        this.placeholderRegistry.registerGlobalPlaceholder(this.plugin, identifier, refreshIntervalTicks, replacementSupplier);
    }

    @Override
    public void registerGlobalPlaceholder(@NotNull String identifier, @NotNull GlobalPlaceholder placeholder) {
        this.checkIdentifier(identifier);
        Preconditions.notNull(placeholder, "placeholder");
        this.placeholderRegistry.registerGlobalPlaceholder(this.plugin, identifier, placeholder);
    }

    @Override
    public void registerGlobalPlaceholderFactory(@NotNull String identifier, @NotNull GlobalPlaceholderFactory placeholderFactory) {
        this.checkIdentifier(identifier);
        Preconditions.notNull(placeholderFactory, "placeholderFactory");
        this.placeholderRegistry.registerGlobalPlaceholderFactory(this.plugin, identifier, placeholderFactory);
    }

    @Override
    public void registerIndividualPlaceholder(@NotNull String identifier, int refreshIntervalTicks, @NotNull IndividualPlaceholderReplacementSupplier replacementSupplier) {
        this.checkIdentifier(identifier);
        Preconditions.checkArgument(refreshIntervalTicks >= 0, "refreshIntervalTicks should be positive");
        Preconditions.notNull(replacementSupplier, "replacementSupplier");
        this.placeholderRegistry.registerIndividualPlaceholder(this.plugin, identifier, refreshIntervalTicks, replacementSupplier);
    }

    @Override
    public void registerIndividualPlaceholder(@NotNull String identifier, @NotNull IndividualPlaceholder placeholder) {
        this.checkIdentifier(identifier);
        Preconditions.notNull(placeholder, "placeholder");
        this.placeholderRegistry.registerIndividualPlaceholder(this.plugin, identifier, placeholder);
    }

    @Override
    public void registerIndividualPlaceholderFactory(@NotNull String identifier, @NotNull IndividualPlaceholderFactory placeholderFactory) {
        this.checkIdentifier(identifier);
        Preconditions.notNull(placeholderFactory, "placeholderFactory");
        this.placeholderRegistry.registerIndividualPlaceholderFactory(this.plugin, identifier, placeholderFactory);
    }

    private void checkIdentifier(String identifier) {
        Preconditions.notEmpty(identifier, "identifier");
        for (char c : identifier.toCharArray()) {
            Preconditions.checkArgument(this.isValidIdentifierCharacter(c), "identifier contains invalid character '" + c + "'");
        }
    }

    private boolean isValidIdentifierCharacter(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '-' || c == '_';
    }

    @Override
    public boolean isRegisteredPlaceholder(@NotNull String identifier) {
        Preconditions.notNull(identifier, "identifier");
        return this.placeholderRegistry.isRegisteredIdentifier(this.plugin, identifier);
    }

    @Override
    @NotNull
    public Collection<Hologram> getHolograms() {
        return this.apiHologramManager.getHologramsByPlugin(this.plugin);
    }

    @Override
    public void deleteHolograms() {
        this.apiHologramManager.deleteHologramsIf(apiHologram -> apiHologram.getCreatorPlugin().equals(this.plugin));
    }

    @Override
    @NotNull
    public Collection<RegisteredPlaceholder> getRegisteredPlaceholders() {
        return this.placeholderRegistry.getRegisteredPlaceholders(this.plugin);
    }

    @Override
    public void unregisterPlaceholder(@NotNull String identifier) {
        Preconditions.notNull(identifier, "identifier");
        this.placeholderRegistry.unregister(this.plugin, identifier);
    }

    @Override
    public void unregisterPlaceholders() {
        this.placeholderRegistry.unregisterAll(this.plugin);
    }
}

