/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.api.current;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import me.filoghost.holographicdisplays.api.beta.HolographicDisplaysAPI;
import me.filoghost.holographicdisplays.api.beta.Position;
import me.filoghost.holographicdisplays.api.beta.internal.HolographicDisplaysAPIProvider;
import me.filoghost.holographicdisplays.plugin.api.current.APIHologramManager;
import me.filoghost.holographicdisplays.plugin.api.current.DefaultHolographicDisplaysAPI;
import me.filoghost.holographicdisplays.plugin.hologram.base.ImmutablePosition;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Preconditions;
import me.filoghost.holographicdisplays.plugin.placeholder.registry.PlaceholderRegistry;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class DefaultHolographicDisplaysAPIProvider
extends HolographicDisplaysAPIProvider {
    private final Map<Plugin, HolographicDisplaysAPI> apiCache = new WeakHashMap<Plugin, HolographicDisplaysAPI>();
    private final Function<Plugin, HolographicDisplaysAPI> apiFactory = plugin -> new DefaultHolographicDisplaysAPI((Plugin)plugin, apiHologramManager, placeholderRegistry);

    public DefaultHolographicDisplaysAPIProvider(APIHologramManager apiHologramManager, PlaceholderRegistry placeholderRegistry) {
    }

    @Override
    public HolographicDisplaysAPI getHolographicDisplaysAPI(Plugin plugin) {
        Preconditions.notNull(plugin, "plugin");
        return this.apiCache.computeIfAbsent(plugin, this.apiFactory);
    }

    @Override
    public Position createPosition(World world, double x, double y, double z) {
        Preconditions.notNull(world, "world");
        return this.createPosition(world.getName(), x, y, z);
    }

    @Override
    public Position createPosition(String worldName, double x, double y, double z) {
        return new ImmutablePosition(worldName, x, y, z);
    }

    @Override
    public Position getPosition(Location location) {
        return ImmutablePosition.of(location);
    }

    @Override
    public Position getPosition(Entity entity) {
        Preconditions.notNull(entity, "entity");
        return this.getPosition(entity.getLocation());
    }

    @Override
    public Position getPosition(Block block) {
        return this.createPosition(block.getWorld(), (double)block.getX(), (double)block.getY(), (double)block.getZ());
    }
}

