/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.api.current;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.filoghost.holographicdisplays.api.beta.hologram.VisibilitySettings;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Preconditions;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class DefaultVisibilitySettings
implements VisibilitySettings {
    private VisibilitySettings.Visibility globalVisibility = VisibilitySettings.Visibility.VISIBLE;
    private Map<UUID, VisibilitySettings.Visibility> individualVisibilities;

    @Override
    @NotNull
    public VisibilitySettings.Visibility getGlobalVisibility() {
        return this.globalVisibility;
    }

    @Override
    public void setGlobalVisibility(@NotNull VisibilitySettings.Visibility visibility) {
        if (this.globalVisibility == visibility) {
            return;
        }
        this.globalVisibility = visibility;
    }

    @Override
    public void setIndividualVisibility(@NotNull Player player, @NotNull VisibilitySettings.Visibility visibility) {
        if (this.individualVisibilities == null) {
            this.individualVisibilities = new ConcurrentHashMap<UUID, VisibilitySettings.Visibility>();
        }
        this.individualVisibilities.put(player.getUniqueId(), visibility);
    }

    @Override
    public boolean isVisibleTo(@NotNull Player player) {
        Preconditions.notNull(player, "player");
        return this.getVisibility(player) == VisibilitySettings.Visibility.VISIBLE;
    }

    private VisibilitySettings.Visibility getVisibility(Player player) {
        VisibilitySettings.Visibility visibility;
        if (this.individualVisibilities != null && (visibility = this.individualVisibilities.get(player.getUniqueId())) != null) {
            return visibility;
        }
        return this.globalVisibility;
    }

    @Override
    public void removeIndividualVisibility(@NotNull Player player) {
        Preconditions.notNull(player, "player");
        if (this.individualVisibilities == null) {
            return;
        }
        this.individualVisibilities.remove(player.getUniqueId());
    }

    @Override
    public void clearIndividualVisibilities() {
        if (this.individualVisibilities == null) {
            return;
        }
        this.individualVisibilities.clear();
    }

    public String toString() {
        return "VisibilitySettings{globalVisibility=" + (Object)((Object)this.globalVisibility) + ", individualVisibilities=" + this.individualVisibilities + "}";
    }
}

