/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import me.filoghost.holographicdisplays.plugin.HolographicDisplays;
import me.filoghost.holographicdisplays.plugin.commands.HologramSubCommand;
import me.filoghost.holographicdisplays.plugin.commands.InternalHologramEditor;
import me.filoghost.holographicdisplays.plugin.commands.subs.AddLineCommand;
import me.filoghost.holographicdisplays.plugin.commands.subs.AlignCommand;
import me.filoghost.holographicdisplays.plugin.commands.subs.CopyCommand;
import me.filoghost.holographicdisplays.plugin.commands.subs.CreateCommand;
import me.filoghost.holographicdisplays.plugin.commands.subs.DebugCommand;
import me.filoghost.holographicdisplays.plugin.commands.subs.DeleteCommand;
import me.filoghost.holographicdisplays.plugin.commands.subs.EditCommand;
import me.filoghost.holographicdisplays.plugin.commands.subs.HelpCommand;
import me.filoghost.holographicdisplays.plugin.commands.subs.InfoCommand;
import me.filoghost.holographicdisplays.plugin.commands.subs.InsertLineCommand;
import me.filoghost.holographicdisplays.plugin.commands.subs.ListCommand;
import me.filoghost.holographicdisplays.plugin.commands.subs.MoveHereCommand;
import me.filoghost.holographicdisplays.plugin.commands.subs.NearCommand;
import me.filoghost.holographicdisplays.plugin.commands.subs.QuickEditCommand;
import me.filoghost.holographicdisplays.plugin.commands.subs.ReadImageCommand;
import me.filoghost.holographicdisplays.plugin.commands.subs.ReadTextCommand;
import me.filoghost.holographicdisplays.plugin.commands.subs.ReloadCommand;
import me.filoghost.holographicdisplays.plugin.commands.subs.RemoveLineCommand;
import me.filoghost.holographicdisplays.plugin.commands.subs.SetLineCommand;
import me.filoghost.holographicdisplays.plugin.commands.subs.TeleportCommand;
import me.filoghost.holographicdisplays.plugin.config.ConfigManager;
import me.filoghost.holographicdisplays.plugin.config.Settings;
import me.filoghost.holographicdisplays.plugin.format.ColorScheme;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologram;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologramManager;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.CommandContext;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.SubCommand;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.SubCommandContext;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.SubCommandManager;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class HologramCommandManager
extends SubCommandManager {
    private final HolographicDisplays holographicDisplays;
    private final List<HologramSubCommand> subCommands;
    private final HelpCommand helpCommand;

    public HologramCommandManager(HolographicDisplays holographicDisplays, InternalHologramManager internalHologramManager, ConfigManager configManager) {
        this.setName("holograms");
        InternalHologramEditor hologramEditor = new InternalHologramEditor(internalHologramManager, configManager);
        this.holographicDisplays = holographicDisplays;
        this.helpCommand = new HelpCommand(this);
        this.subCommands = new ArrayList<HologramSubCommand>();
        this.subCommands.add(new AddLineCommand(this, hologramEditor));
        this.subCommands.add(new CreateCommand(hologramEditor));
        this.subCommands.add(new DeleteCommand(hologramEditor));
        this.subCommands.add(new EditCommand(this, hologramEditor));
        this.subCommands.add(new ListCommand(hologramEditor));
        this.subCommands.add(new NearCommand(hologramEditor));
        this.subCommands.add(new TeleportCommand(hologramEditor));
        this.subCommands.add(new MoveHereCommand(hologramEditor));
        this.subCommands.add(new AlignCommand(hologramEditor));
        this.subCommands.add(new CopyCommand(hologramEditor));
        this.subCommands.add(new ReloadCommand(holographicDisplays));
        this.subCommands.add(new RemoveLineCommand(this, hologramEditor));
        this.subCommands.add(new SetLineCommand(this, hologramEditor));
        this.subCommands.add(new InsertLineCommand(this, hologramEditor));
        this.subCommands.add(new ReadTextCommand(hologramEditor));
        this.subCommands.add(new ReadImageCommand(hologramEditor));
        this.subCommands.add(new InfoCommand(this, hologramEditor));
        this.subCommands.add(new DebugCommand());
        this.subCommands.add(this.helpCommand);
    }

    @Override
    protected SubCommand getSubCommandByName(String name) {
        for (HologramSubCommand subCommand : this.subCommands) {
            if (subCommand.getName().equalsIgnoreCase(name)) {
                return subCommand;
            }
            for (String alias : subCommand.getAliases()) {
                if (!alias.equalsIgnoreCase(name)) continue;
                return subCommand;
            }
        }
        return null;
    }

    public void sendQuickEditCommands(SubCommandContext commandContext, InternalHologram hologram) {
        if (!Settings.quickEditCommands) {
            return;
        }
        if (!(commandContext.getSender() instanceof Player)) {
            return;
        }
        ComponentBuilder message = new ComponentBuilder("EDIT LINES:").color(ChatColor.GRAY).bold(true).append("  ", ComponentBuilder.FormatRetention.NONE);
        for (HologramSubCommand subCommand : this.subCommands) {
            if (!(subCommand instanceof QuickEditCommand)) continue;
            QuickEditCommand quickEditCommand = (QuickEditCommand)((Object)subCommand);
            String usageArgs = subCommand.getUsageArgs();
            usageArgs = usageArgs != null && usageArgs.contains(" ") ? usageArgs.substring(usageArgs.indexOf(" ") + 1) : "";
            String usage = "/" + commandContext.getRootLabel() + " " + subCommand.getName() + " " + hologram.getName() + " ";
            message.append("[" + quickEditCommand.getActionName() + "]").color(ChatColor.DARK_AQUA).event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, usage)).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)(ChatColor.GRAY + "Click to insert in chat the highlighted part of the command:\n" + ChatColor.YELLOW + usage + ChatColor.DARK_GRAY + usageArgs))));
            message.append("  ", ComponentBuilder.FormatRetention.NONE);
        }
        ((Player)commandContext.getSender()).spigot().sendMessage(message.create());
    }

    public Iterable<HologramSubCommand> getSubCommands() {
        return this.subCommands;
    }

    @Override
    protected void sendNoArgsMessage(CommandContext context) {
        CommandSender sender = context.getSender();
        String version = this.holographicDisplays.getDescription().getVersion();
        sender.sendMessage(ColorScheme.PRIMARY_DARK + "Server is running " + ColorScheme.PRIMARY + "Holographic Displays " + ColorScheme.PRIMARY_DARK + "v" + version + " by " + ColorScheme.PRIMARY + "filoghost");
        if (this.helpCommand.hasPermission((Permissible)sender)) {
            sender.sendMessage(ColorScheme.PRIMARY_DARK + "Commands: " + ColorScheme.PRIMARY + this.helpCommand.getFullUsageText(context));
        }
    }

    @Override
    protected void sendSubCommandDefaultPermissionMessage(SubCommandContext context) {
        context.getSender().sendMessage(ColorScheme.ERROR + "You don't have permission for this sub-command.");
    }

    @Override
    protected void sendUnknownSubCommandMessage(SubCommandContext context) {
        context.getSender().sendMessage(ColorScheme.ERROR + "Unknown sub-command. Type \"" + this.helpCommand.getFullUsageText(context) + "\" for a list of commands.");
    }

    @Override
    protected void sendSubCommandUsage(SubCommandContext context) {
        context.getSender().sendMessage(ColorScheme.ERROR + "Usage: /" + context.getRootLabel() + " " + context.getSubLabel() + " " + context.getSubCommand().getUsageArgs());
    }

    @Override
    protected void sendExecutionErrorMessage(CommandContext context, String errorMessage) {
        context.getSender().sendMessage(ColorScheme.ERROR + errorMessage);
    }

    @Override
    protected void handleUnexpectedException(CommandContext context, Throwable t) {
        Bukkit.getLogger().log(Level.SEVERE, "Unhandled exception while executing /" + context.getRootLabel(), t);
        context.getSender().sendMessage(ColorScheme.ERROR + "Internal error while executing command. Please look on the console for more details.");
    }
}

