/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.commands;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import me.filoghost.holographicdisplays.plugin.config.ConfigManager;
import me.filoghost.holographicdisplays.plugin.config.HologramLineParser;
import me.filoghost.holographicdisplays.plugin.config.HologramLoadException;
import me.filoghost.holographicdisplays.plugin.event.InternalHologramChangeEvent;
import me.filoghost.holographicdisplays.plugin.hologram.base.ImmutablePosition;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologram;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologramLine;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologramManager;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Strings;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandValidate;
import me.filoghost.holographicdisplays.plugin.util.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.NotNull;

public class InternalHologramEditor {
    private final InternalHologramManager internalHologramManager;
    private final ConfigManager configManager;

    public InternalHologramEditor(InternalHologramManager internalHologramManager, ConfigManager configManager) {
        this.internalHologramManager = internalHologramManager;
        this.configManager = configManager;
    }

    public InternalHologramLine parseHologramLine(InternalHologram hologram, String serializedLine) throws CommandException {
        try {
            return HologramLineParser.parseLine(hologram, serializedLine);
        }
        catch (HologramLoadException e) {
            throw new CommandException(this.formatExceptionMessage(e));
        }
    }

    private String formatExceptionMessage(Throwable throwable) {
        String message = throwable.getMessage();
        if (Strings.isEmpty(message)) {
            return message;
        }
        if (!Strings.hasSentenceEnding(message = Strings.capitalizeFirst(message))) {
            message = message + ".";
        }
        return message;
    }

    public boolean hologramExists(String hologramName) {
        return this.internalHologramManager.getHologramByName(hologramName) != null;
    }

    @NotNull
    public InternalHologram getExistingHologram(String hologramName) throws CommandException {
        InternalHologram hologram = this.internalHologramManager.getHologramByName(hologramName);
        CommandValidate.notNull(hologram, "Cannot find a hologram named \"" + hologramName + "\".");
        return hologram;
    }

    public List<InternalHologram> getHolograms() {
        return this.internalHologramManager.getHolograms();
    }

    public InternalHologram create(ImmutablePosition spawnPosition, String hologramName) {
        return this.internalHologramManager.createHologram(spawnPosition, hologramName);
    }

    public void delete(InternalHologram hologram) {
        this.internalHologramManager.deleteHologram(hologram);
    }

    public void saveChanges(InternalHologram hologram, InternalHologramChangeEvent.ChangeType changeType) {
        this.configManager.saveHologramDatabase(this.internalHologramManager);
        Bukkit.getPluginManager().callEvent((Event)new InternalHologramChangeEvent(hologram, changeType));
    }

    public void teleportLookingDown(Player player, Location location) {
        location.setPitch(90.0f);
        player.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public Path getUserReadableFile(String fileName) throws CommandException {
        Path dataFolder = this.configManager.getRootDataFolder();
        Path targetFile = dataFolder.resolve(fileName);
        CommandValidate.check(FileUtils.isInsideDirectory(targetFile, dataFolder), "The specified file must be inside HolographicDisplays' folder.");
        CommandValidate.check(Files.exists(targetFile, new LinkOption[0]), "The specified file \"" + fileName + "\" does not exist inside HolographicDisplays' folder.");
        CommandValidate.check(!Files.isDirectory(targetFile, new LinkOption[0]), "The file cannot be a folder.");
        CommandValidate.check(!InternalHologramEditor.isConfigFile(targetFile), "Cannot read YML configuration files.");
        return targetFile;
    }

    private static boolean isConfigFile(Path file) {
        return Files.isRegularFile(file, new LinkOption[0]) && FileUtils.hasFileExtension(file, "yml");
    }
}

