/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.commands.subs;

import me.filoghost.holographicdisplays.plugin.commands.HologramSubCommand;
import me.filoghost.holographicdisplays.plugin.commands.InternalHologramEditor;
import me.filoghost.holographicdisplays.plugin.event.InternalHologramChangeEvent;
import me.filoghost.holographicdisplays.plugin.format.ColorScheme;
import me.filoghost.holographicdisplays.plugin.hologram.base.ImmutablePosition;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologram;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.SubCommandContext;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandValidate;
import org.bukkit.command.CommandSender;

public class AlignCommand
extends HologramSubCommand {
    private final InternalHologramEditor hologramEditor;

    public AlignCommand(InternalHologramEditor hologramEditor) {
        super("align", new String[0]);
        this.setMinArgs(3);
        this.setUsageArgs("<X | Y | Z | XZ> <hologramToAlign> <referenceHologram>");
        this.setDescription("Aligns a hologram to another along the specified axis.");
        this.hologramEditor = hologramEditor;
    }

    @Override
    public void execute(CommandSender sender, String[] args, SubCommandContext context) throws CommandException {
        InternalHologram referenceHologram;
        InternalHologram hologram = this.hologramEditor.getExistingHologram(args[1]);
        CommandValidate.check(hologram != (referenceHologram = this.hologramEditor.getExistingHologram(args[2])), "The holograms must not be the same.");
        ImmutablePosition referencePosition = referenceHologram.getPosition();
        ImmutablePosition newPosition = hologram.getPosition();
        String axis = args[0];
        if (axis.equalsIgnoreCase("x")) {
            newPosition = newPosition.withX(referencePosition.getX());
        } else if (axis.equalsIgnoreCase("y")) {
            newPosition = newPosition.withY(referencePosition.getY());
        } else if (axis.equalsIgnoreCase("z")) {
            newPosition = newPosition.withZ(referencePosition.getZ());
        } else if (axis.equalsIgnoreCase("xz")) {
            newPosition = newPosition.withX(referencePosition.getX());
            newPosition = newPosition.withZ(referencePosition.getZ());
        } else {
            throw new CommandException("You must specify either X, Y, Z or XZ, " + axis + " is not a valid axis.");
        }
        hologram.setPosition(newPosition);
        this.hologramEditor.saveChanges(hologram, InternalHologramChangeEvent.ChangeType.EDIT_POSITION);
        sender.sendMessage(ColorScheme.PRIMARY + "Hologram \"" + hologram.getName() + "\" aligned to the hologram \"" + referenceHologram.getName() + "\" on the " + axis.toUpperCase() + " axis.");
    }
}

