/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.commands.subs;

import me.filoghost.holographicdisplays.plugin.commands.HologramSubCommand;
import me.filoghost.holographicdisplays.plugin.commands.InternalHologramEditor;
import me.filoghost.holographicdisplays.plugin.event.InternalHologramChangeEvent;
import me.filoghost.holographicdisplays.plugin.format.ColorScheme;
import me.filoghost.holographicdisplays.plugin.hologram.base.ImmutablePosition;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologram;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologramLine;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Strings;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.SubCommandContext;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandValidate;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CreateCommand
extends HologramSubCommand {
    private final InternalHologramEditor hologramEditor;

    public CreateCommand(InternalHologramEditor hologramEditor) {
        super("create", new String[0]);
        this.setMinArgs(1);
        this.setUsageArgs("<hologramName> [text]");
        this.setDescription("Creates a new hologram with the given name, that must", "be alphanumeric. The name will be used as reference to", "that hologram for editing commands.");
        this.hologramEditor = hologramEditor;
    }

    @Override
    public void execute(CommandSender sender, String[] args, SubCommandContext context) throws CommandException {
        InternalHologramLine line;
        Player player = CommandValidate.getPlayerSender(sender);
        String hologramName = args[0];
        CommandValidate.check(hologramName.matches("[a-zA-Z0-9_\\-]+"), "The name must contain only alphanumeric characters, underscores and hyphens.");
        CommandValidate.check(!this.hologramEditor.hologramExists(hologramName), "A hologram with that name already exists.");
        ImmutablePosition spawnPosition = ImmutablePosition.of(player.getLocation());
        boolean moveUp = player.isOnGround();
        if (moveUp) {
            spawnPosition = spawnPosition.add(0.0, 1.2, 0.0);
        }
        InternalHologram hologram = this.hologramEditor.create(spawnPosition, hologramName);
        if (args.length > 1) {
            String text = Strings.joinFrom(" ", args, 1);
            line = this.hologramEditor.parseHologramLine(hologram, text);
            player.sendMessage(ColorScheme.SECONDARY_DARK + "(Change the lines with /" + context.getRootLabel() + " edit " + hologram.getName() + ")");
        } else {
            String defaultText = "Default hologram. Change it with " + ColorScheme.PRIMARY + "/" + context.getRootLabel() + " edit " + hologram.getName();
            line = hologram.createTextLine(defaultText, defaultText.replace('\u00a7', '&'));
        }
        hologram.getLines().add(line);
        this.hologramEditor.saveChanges(hologram, InternalHologramChangeEvent.ChangeType.CREATE);
        this.hologramEditor.teleportLookingDown(player, player.getLocation());
        player.sendMessage(ColorScheme.PRIMARY + "Hologram named \"" + hologram.getName() + "\" created.");
        if (moveUp) {
            player.sendMessage(ColorScheme.SECONDARY_DARK + "(You were on the ground, the hologram was automatically moved up. If you use /" + context.getRootLabel() + " moveHere " + hologram.getName() + ", the hologram will be moved to your feet)");
        }
    }
}

