/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.commands.subs;

import me.filoghost.holographicdisplays.plugin.commands.HologramCommandManager;
import me.filoghost.holographicdisplays.plugin.commands.HologramSubCommand;
import me.filoghost.holographicdisplays.plugin.commands.InternalHologramEditor;
import me.filoghost.holographicdisplays.plugin.commands.subs.LineEditingCommand;
import me.filoghost.holographicdisplays.plugin.format.DisplayFormat;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologram;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.SubCommandContext;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EditCommand
extends HologramSubCommand {
    private final HologramCommandManager commandManager;
    private final InternalHologramEditor hologramEditor;

    public EditCommand(HologramCommandManager commandManager, InternalHologramEditor hologramEditor) {
        super("edit", new String[0]);
        this.setMinArgs(1);
        this.setUsageArgs("<hologram>");
        this.setDescription("Lists the commands to edit a hologram.");
        this.commandManager = commandManager;
        this.hologramEditor = hologramEditor;
    }

    @Override
    public void execute(CommandSender sender, String[] args, SubCommandContext context) throws CommandException {
        InternalHologram hologram = this.hologramEditor.getExistingHologram(args[0]);
        DisplayFormat.sendTitle(sender, "How to edit the hologram \"" + hologram.getName() + "\"");
        for (HologramSubCommand subCommand : this.commandManager.getSubCommands()) {
            if (!(subCommand instanceof LineEditingCommand)) continue;
            DisplayFormat.sendCommandDescription(sender, subCommand.getFullUsageText(context).replace("<hologram>", hologram.getName()), subCommand.getDescription(context));
        }
        if (sender instanceof Player) {
            DisplayFormat.sendHoverCommandDescriptionTip((Player)sender);
        }
    }
}

