/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.commands.subs;

import me.filoghost.holographicdisplays.plugin.commands.HologramCommandManager;
import me.filoghost.holographicdisplays.plugin.commands.InternalHologramEditor;
import me.filoghost.holographicdisplays.plugin.commands.subs.LineEditingCommand;
import me.filoghost.holographicdisplays.plugin.commands.subs.QuickEditCommand;
import me.filoghost.holographicdisplays.plugin.event.InternalHologramChangeEvent;
import me.filoghost.holographicdisplays.plugin.format.ColorScheme;
import me.filoghost.holographicdisplays.plugin.format.DisplayFormat;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologram;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologramLine;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Strings;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.SubCommandContext;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandValidate;
import org.bukkit.command.CommandSender;

public class InsertLineCommand
extends LineEditingCommand
implements QuickEditCommand {
    private final HologramCommandManager commandManager;
    private final InternalHologramEditor hologramEditor;

    public InsertLineCommand(HologramCommandManager commandManager, InternalHologramEditor hologramEditor) {
        super("insertLine", new String[0]);
        this.setMinArgs(3);
        this.setUsageArgs("<hologram> <lineNumber> <text>");
        this.setDescription("Inserts a line after the specified line number.", "To insert at the top of the hologram, use \"0\" for the line number.");
        this.commandManager = commandManager;
        this.hologramEditor = hologramEditor;
    }

    @Override
    public void execute(CommandSender sender, String[] args, SubCommandContext context) throws CommandException {
        InternalHologram hologram = this.hologramEditor.getExistingHologram(args[0]);
        int insertAfterIndex = CommandValidate.parseInteger(args[1]);
        String serializedLine = Strings.joinFrom(" ", args, 2);
        int oldLinesAmount = hologram.getLines().size();
        CommandValidate.check(insertAfterIndex >= 0 && insertAfterIndex <= oldLinesAmount, "The line number must be between 0 and " + oldLinesAmount + ".");
        InternalHologramLine line = this.hologramEditor.parseHologramLine(hologram, serializedLine);
        hologram.getLines().insert(insertAfterIndex, line);
        this.hologramEditor.saveChanges(hologram, InternalHologramChangeEvent.ChangeType.EDIT_LINES);
        if (insertAfterIndex == 0) {
            sender.sendMessage(ColorScheme.PRIMARY + "Line inserted before the first line.");
        } else if (insertAfterIndex == oldLinesAmount) {
            sender.sendMessage(ColorScheme.PRIMARY + "Line appended at the end.");
            DisplayFormat.sendTip(sender, "You can use \"/" + context.getRootLabel() + " addLine\" to append a line at the end.");
        } else {
            sender.sendMessage(ColorScheme.PRIMARY + "Line inserted between the lines " + insertAfterIndex + " and " + (insertAfterIndex + 1) + ".");
        }
        this.commandManager.sendQuickEditCommands(context, hologram);
    }

    @Override
    public String getActionName() {
        return "Insert";
    }
}

