/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.commands.subs;

import java.util.List;
import me.filoghost.holographicdisplays.plugin.commands.HologramSubCommand;
import me.filoghost.holographicdisplays.plugin.commands.InternalHologramEditor;
import me.filoghost.holographicdisplays.plugin.format.ColorScheme;
import me.filoghost.holographicdisplays.plugin.format.DisplayFormat;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologram;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.SubCommandContext;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandValidate;
import org.bukkit.command.CommandSender;

public class ListCommand
extends HologramSubCommand {
    private static final int HOLOGRAMS_PER_PAGE = 10;
    private final InternalHologramEditor hologramEditor;

    public ListCommand(InternalHologramEditor hologramEditor) {
        super("list", new String[0]);
        this.setMinArgs(0);
        this.setUsageArgs("[page]");
        this.setDescription("Lists all the existing holograms.");
        this.hologramEditor = hologramEditor;
    }

    @Override
    public void execute(CommandSender sender, String[] args, SubCommandContext context) throws CommandException {
        int page = args.length > 0 ? CommandValidate.parseInteger(args[0]) : 1;
        CommandValidate.check(page >= 1, "Page number must be 1 or greater.");
        List<InternalHologram> holograms = this.hologramEditor.getHolograms();
        int totalPages = holograms.size() / 10;
        if (holograms.size() % 10 != 0) {
            ++totalPages;
        }
        CommandValidate.check(holograms.size() > 0, "There are no holograms yet. Create one with /" + context.getRootLabel() + " create.");
        DisplayFormat.sendTitle(sender, "Holograms list " + ColorScheme.SECONDARY + "(Page " + page + " of " + totalPages + ")");
        int fromIndex = (page - 1) * 10;
        int toIndex = fromIndex + 10;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (i >= holograms.size()) continue;
            DisplayFormat.sendHologramSummary(sender, holograms.get(i), true);
        }
        if (page < totalPages) {
            DisplayFormat.sendTip(sender, "See the next page with /" + context.getRootLabel() + " list " + (page + 1));
        }
    }
}

