/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.commands.subs;

import me.filoghost.holographicdisplays.plugin.commands.HologramSubCommand;
import me.filoghost.holographicdisplays.plugin.commands.InternalHologramEditor;
import me.filoghost.holographicdisplays.plugin.event.InternalHologramChangeEvent;
import me.filoghost.holographicdisplays.plugin.format.ColorScheme;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologram;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.SubCommandContext;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandValidate;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MoveHereCommand
extends HologramSubCommand {
    private final InternalHologramEditor hologramEditor;

    public MoveHereCommand(InternalHologramEditor hologramEditor) {
        super("moveHere", new String[0]);
        this.setMinArgs(1);
        this.setUsageArgs("<hologram>");
        this.setDescription("Moves a hologram to your position.");
        this.hologramEditor = hologramEditor;
    }

    @Override
    public void execute(CommandSender sender, String[] args, SubCommandContext context) throws CommandException {
        Player player = CommandValidate.getPlayerSender(sender);
        InternalHologram hologram = this.hologramEditor.getExistingHologram(args[0]);
        hologram.setPosition(player.getLocation());
        this.hologramEditor.saveChanges(hologram, InternalHologramChangeEvent.ChangeType.EDIT_POSITION);
        this.hologramEditor.teleportLookingDown(player, player.getLocation());
        player.sendMessage(ColorScheme.PRIMARY + "Hologram \"" + hologram.getName() + "\" moved to your position.");
    }
}

