/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.commands.subs;

import me.filoghost.holographicdisplays.plugin.commands.HologramSubCommand;
import me.filoghost.holographicdisplays.plugin.commands.InternalHologramEditor;
import me.filoghost.holographicdisplays.plugin.format.ColorScheme;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologram;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.SubCommandContext;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandValidate;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeleportCommand
extends HologramSubCommand {
    private final InternalHologramEditor hologramEditor;

    public TeleportCommand(InternalHologramEditor hologramEditor) {
        super("teleport", "tp");
        this.setMinArgs(1);
        this.setUsageArgs("<hologram>");
        this.setDescription("Teleports to a hologram.");
        this.hologramEditor = hologramEditor;
    }

    @Override
    public void execute(CommandSender sender, String[] args, SubCommandContext context) throws CommandException {
        Player player = CommandValidate.getPlayerSender(sender);
        InternalHologram hologram = this.hologramEditor.getExistingHologram(args[0]);
        this.hologramEditor.teleportLookingDown(player, hologram.getPosition().toLocation());
        player.sendMessage(ColorScheme.PRIMARY + "Teleported to the hologram \"" + hologram.getName() + "\".");
    }
}

