/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.stream.Stream;
import me.filoghost.holographicdisplays.plugin.config.AnimationConfig;
import me.filoghost.holographicdisplays.plugin.config.HologramDatabase;
import me.filoghost.holographicdisplays.plugin.config.Settings;
import me.filoghost.holographicdisplays.plugin.config.SettingsModel;
import me.filoghost.holographicdisplays.plugin.config.StaticReplacements;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologramManager;
import me.filoghost.holographicdisplays.plugin.internal.placeholder.AnimationPlaceholder;
import me.filoghost.holographicdisplays.plugin.internal.placeholder.AnimationPlaceholderFactory;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.BaseConfigManager;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.Config;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigErrors;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigLoader;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.FileConfig;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigLoadException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigSaveException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigValueException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.mapped.MappedConfigLoader;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.logging.ErrorCollector;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.logging.Log;
import me.filoghost.holographicdisplays.plugin.util.FileUtils;

public class ConfigManager
extends BaseConfigManager {
    private final MappedConfigLoader<SettingsModel> mainConfigLoader = this.getMappedConfigLoader("config.yml", SettingsModel.class);
    private final ConfigLoader databaseConfigLoader = this.getConfigLoader("database.yml");
    private final ConfigLoader staticReplacementsConfigLoader = this.getConfigLoader("custom-placeholders.yml");

    public ConfigManager(Path rootDataFolder) {
        super(rootDataFolder);
    }

    public void reloadMainSettings(ErrorCollector errorCollector) {
        SettingsModel mainConfig;
        try {
            mainConfig = this.mainConfigLoader.init();
        }
        catch (ConfigException e) {
            this.logConfigException(errorCollector, this.mainConfigLoader.getFile(), e);
            mainConfig = new SettingsModel();
        }
        Settings.load(mainConfig, errorCollector);
    }

    public HologramDatabase loadHologramDatabase(ErrorCollector errorCollector) {
        Config databaseConfig;
        try {
            databaseConfig = this.databaseConfigLoader.init();
        }
        catch (ConfigException e) {
            this.logConfigException(errorCollector, this.databaseConfigLoader.getFile(), e);
            databaseConfig = new Config();
        }
        HologramDatabase hologramDatabase = new HologramDatabase();
        hologramDatabase.loadFromConfig(databaseConfig);
        return hologramDatabase;
    }

    public void saveHologramDatabase(InternalHologramManager hologramManager) {
        try {
            this.databaseConfigLoader.save(HologramDatabase.exportToConfig(hologramManager));
        }
        catch (ConfigException e) {
            Log.severe("Error while saving holograms database file \"" + this.formatPath(this.databaseConfigLoader.getFile()) + "\"", e);
        }
    }

    public AnimationPlaceholderFactory loadAnimations(ErrorCollector errorCollector) {
        HashMap<String, AnimationPlaceholder> animationsByFileName = new HashMap<String, AnimationPlaceholder>();
        Path animationsFolder = this.getAnimationsFolder();
        try {
            if (!Files.isDirectory(animationsFolder, new LinkOption[0])) {
                Files.createDirectories(animationsFolder, new FileAttribute[0]);
                try {
                    Path exampleAnimationFile = animationsFolder.resolve("example.yml");
                    this.getConfigLoader(exampleAnimationFile).createDefault();
                }
                catch (ConfigSaveException e) {
                    errorCollector.add(e, "could not add example animation file");
                }
            }
            try (Stream<Path> animationFiles = Files.list(animationsFolder);){
                animationFiles.filter(this::isYamlFile).forEach(file -> {
                    try {
                        String fileName = file.getFileName().toString();
                        AnimationConfig animationConfig = this.loadAnimation((Path)file);
                        AnimationPlaceholder animationPlaceholder = new AnimationPlaceholder(animationConfig.getIntervalTicks(), animationConfig.getFrames());
                        animationsByFileName.put(fileName, animationPlaceholder);
                    }
                    catch (ConfigException e) {
                        this.logConfigException(errorCollector, (Path)file, e);
                    }
                });
            }
        }
        catch (IOException e) {
            errorCollector.add(e, "error loading animation files");
        }
        return new AnimationPlaceholderFactory(animationsByFileName);
    }

    private AnimationConfig loadAnimation(Path animationFile) throws ConfigLoadException, ConfigValueException {
        FileConfig animationFileConfig = this.getConfigLoader(animationFile).load();
        return new AnimationConfig(animationFileConfig);
    }

    public void reloadStaticReplacements(ErrorCollector errorCollector) {
        FileConfig staticReplacementsConfig;
        try {
            staticReplacementsConfig = this.staticReplacementsConfigLoader.init();
        }
        catch (ConfigException e) {
            this.logConfigException(errorCollector, this.staticReplacementsConfigLoader.getFile(), e);
            staticReplacementsConfig = new FileConfig(this.staticReplacementsConfigLoader.getFile());
        }
        StaticReplacements.load(staticReplacementsConfig, errorCollector);
    }

    public Path getAnimationsFolder() {
        return this.getRootDataFolder().resolve("animations");
    }

    private boolean isYamlFile(Path file) {
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return false;
        }
        return FileUtils.hasFileExtension(file, "yml", "yaml");
    }

    private void logConfigException(ErrorCollector errorCollector, Path file, ConfigException e) {
        errorCollector.add(e, "error while loading config file \"" + this.formatPath(file) + "\"");
    }

    public String formatPath(Path path) {
        return ConfigErrors.formatPath(this.getRootDataFolder(), path);
    }
}

