/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.config;

import java.util.ArrayList;
import java.util.List;
import me.filoghost.holographicdisplays.plugin.config.HologramLineParser;
import me.filoghost.holographicdisplays.plugin.config.HologramLoadException;
import me.filoghost.holographicdisplays.plugin.hologram.base.ImmutablePosition;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologram;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologramLine;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologramManager;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigSection;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigValueException;

public class HologramConfig {
    private final String name;
    private final List<String> serializedLines;
    private final ConfigSection positionConfigSection;

    public HologramConfig(String name, ConfigSection configSection) {
        this.name = name;
        this.serializedLines = configSection.getStringList("lines");
        this.positionConfigSection = configSection.getConfigSection("position");
    }

    public HologramConfig(InternalHologram hologram) {
        this.name = hologram.getName();
        this.serializedLines = new ArrayList<String>();
        for (InternalHologramLine line : hologram.getLines()) {
            this.serializedLines.add(line.getSerializedConfigValue());
        }
        ImmutablePosition position = hologram.getPosition();
        this.positionConfigSection = new ConfigSection();
        this.positionConfigSection.setString("world", position.getWorldName());
        this.positionConfigSection.setDouble("x", position.getX());
        this.positionConfigSection.setDouble("y", position.getY());
        this.positionConfigSection.setDouble("z", position.getZ());
    }

    public ConfigSection toConfigSection() {
        ConfigSection configSection = new ConfigSection();
        configSection.setStringList("lines", this.serializedLines);
        configSection.setConfigSection("position", this.positionConfigSection);
        return configSection;
    }

    public void createHologram(InternalHologramManager internalHologramManager) throws HologramLoadException {
        if (this.serializedLines == null || this.serializedLines.size() == 0) {
            throw new HologramLoadException("at least one line is required");
        }
        if (this.positionConfigSection == null) {
            throw new HologramLoadException("no position set");
        }
        ImmutablePosition position = this.parsePosition();
        InternalHologram hologram = internalHologramManager.createHologram(position, this.name);
        ArrayList<InternalHologramLine> lines = new ArrayList<InternalHologramLine>();
        for (String serializedLine : this.serializedLines) {
            try {
                lines.add(HologramLineParser.parseLine(hologram, serializedLine));
            }
            catch (HologramLoadException e) {
                throw new HologramLoadException("invalid line: " + e.getMessage(), e);
            }
        }
        hologram.getLines().addAll(lines);
    }

    private ImmutablePosition parsePosition() throws HologramLoadException {
        try {
            String worldName = this.positionConfigSection.getRequiredString("world");
            double x = this.positionConfigSection.getRequiredDouble("x");
            double y = this.positionConfigSection.getRequiredDouble("y");
            double z = this.positionConfigSection.getRequiredDouble("z");
            return new ImmutablePosition(worldName, x, y, z);
        }
        catch (ConfigValueException e) {
            throw new HologramLoadException("invalid position attribute \"" + e.getConfigPath() + "\"", e);
        }
    }

    public String getName() {
        return this.name;
    }
}

