/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.filoghost.holographicdisplays.plugin.config.HologramConfig;
import me.filoghost.holographicdisplays.plugin.config.HologramLoadException;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologram;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologramManager;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.Config;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigPath;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigSection;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigType;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.logging.ErrorCollector;

public class HologramDatabase {
    private static List<HologramConfig> hologramConfigs;

    public void loadFromConfig(Config config) {
        hologramConfigs = new ArrayList<HologramConfig>();
        for (Map.Entry<ConfigPath, ConfigSection> entry : config.toMap(ConfigType.SECTION).entrySet()) {
            String hologramName = entry.getKey().asRawKey();
            ConfigSection hologramSection = entry.getValue();
            HologramConfig hologramConfig = new HologramConfig(hologramName, hologramSection);
            hologramConfigs.add(hologramConfig);
        }
    }

    public void createHolograms(InternalHologramManager internalHologramManager, ErrorCollector errorCollector) {
        for (HologramConfig hologramConfig : hologramConfigs) {
            try {
                hologramConfig.createHologram(internalHologramManager);
            }
            catch (HologramLoadException e) {
                errorCollector.add(e, "error while loading hologram \"" + hologramConfig.getName() + "\"");
            }
            catch (Exception e) {
                errorCollector.add(e, "unexpected exception while loading hologram \"" + hologramConfig.getName() + "\"");
            }
        }
    }

    public static Config exportToConfig(InternalHologramManager hologramManager) {
        Config config = new Config();
        for (InternalHologram hologram : hologramManager.getHolograms()) {
            config.setConfigSection(hologram.getName(), new HologramConfig(hologram).toConfigSection());
        }
        config.setHeader("", "Please do NOT edit this file manually if possible.", "");
        return config;
    }
}

