/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.config.upgrade;

import java.nio.file.Path;
import me.filoghost.holographicdisplays.plugin.config.ConfigManager;
import me.filoghost.holographicdisplays.plugin.config.upgrade.LegacyUpgrade;
import me.filoghost.holographicdisplays.plugin.config.upgrade.LegacyUpgradeTask;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Strings;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigLoader;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigSection;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigType;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigValue;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.FileConfig;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.logging.ErrorCollector;

public class DatabaseLegacyUpgrade
extends LegacyUpgrade
implements LegacyUpgradeTask {
    private final ConfigLoader databaseConfigLoader;

    public DatabaseLegacyUpgrade(ConfigManager configManager, ErrorCollector errorCollector) {
        super(configManager, errorCollector);
        this.databaseConfigLoader = configManager.getConfigLoader("database.yml");
    }

    @Override
    public Path getFile() {
        return this.databaseConfigLoader.getFile();
    }

    @Override
    public void run() throws ConfigException {
        if (!this.databaseConfigLoader.fileExists()) {
            return;
        }
        FileConfig databaseConfig = this.databaseConfigLoader.load();
        boolean changed = false;
        for (ConfigSection hologramSection : databaseConfig.toMap(ConfigType.SECTION).values()) {
            String legacySerializedLocation;
            if (hologramSection.contains("position") || (legacySerializedLocation = hologramSection.getString("location")) == null) continue;
            hologramSection.remove("location");
            hologramSection.setConfigSection("position", this.convertLegacySerializedLocation(legacySerializedLocation));
            changed = true;
        }
        if (changed) {
            this.createBackupFile(this.databaseConfigLoader.getFile());
            this.databaseConfigLoader.save(databaseConfig);
        }
    }

    private ConfigSection convertLegacySerializedLocation(String legacySerializedLocation) {
        String[] legacyLocationParts = Strings.splitAndTrim(legacySerializedLocation, ",");
        ConfigSection positionSection = new ConfigSection();
        positionSection.setString("world", legacyLocationParts[0]);
        if (legacyLocationParts.length > 1) {
            positionSection.set("x", DatabaseLegacyUpgrade.getDoubleOrString(legacyLocationParts[1]));
        }
        if (legacyLocationParts.length > 2) {
            positionSection.set("y", DatabaseLegacyUpgrade.getDoubleOrString(legacyLocationParts[2]));
        }
        if (legacyLocationParts.length > 3) {
            positionSection.set("z", DatabaseLegacyUpgrade.getDoubleOrString(legacyLocationParts[3]));
        }
        return positionSection;
    }

    private static ConfigValue getDoubleOrString(String serializedDouble) {
        try {
            return ConfigValue.of(ConfigType.DOUBLE, Double.parseDouble(serializedDouble));
        }
        catch (NumberFormatException e) {
            return ConfigValue.of(ConfigType.STRING, serializedDouble);
        }
    }
}

