/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.config.upgrade;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import me.filoghost.holographicdisplays.plugin.config.ConfigManager;
import me.filoghost.holographicdisplays.plugin.config.upgrade.LegacyUpgrade;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Strings;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.Config;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigLoader;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigPath;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigSection;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigLoadException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.logging.ErrorCollector;
import org.apache.commons.lang.StringEscapeUtils;

public class SymbolsLegacyUpgrade
extends LegacyUpgrade {
    private final Path oldFile;

    public SymbolsLegacyUpgrade(ConfigManager configManager, ErrorCollector errorCollector) {
        super(configManager, errorCollector);
        this.oldFile = configManager.getRootDataFolder().resolve("symbols.yml");
    }

    @Override
    protected Path getFile() {
        return this.oldFile;
    }

    @Override
    public void run() throws IOException, ConfigException {
        List<String> lines;
        ConfigLoader newConfigLoader = this.configManager.getConfigLoader("custom-placeholders.yml");
        Path newFile = newConfigLoader.getFile();
        if (!Files.isRegularFile(this.oldFile, new LinkOption[0])) {
            return;
        }
        if (Files.isRegularFile(newFile, new LinkOption[0])) {
            return;
        }
        Config newConfig = new Config();
        ConfigSection placeholdersSection = newConfig.getOrCreateSection("placeholders");
        try {
            lines = Files.readAllLines(this.oldFile);
        }
        catch (IOException e) {
            throw new ConfigLoadException("I/O exception while reading file", e);
        }
        for (String line : lines) {
            if (line.isEmpty() || line.startsWith("#") || !line.contains(":")) continue;
            String[] placeholderAndReplacement = Strings.splitAndTrim(line, ":", 2);
            String placeholder = SymbolsLegacyUpgrade.unquote(placeholderAndReplacement[0]);
            String replacement = StringEscapeUtils.unescapeJava((String)SymbolsLegacyUpgrade.unquote(placeholderAndReplacement[1]));
            placeholdersSection.setString(ConfigPath.literal(placeholder), replacement);
        }
        this.createBackupFile(this.oldFile);
        newConfigLoader.save(newConfig);
        Files.delete(this.oldFile);
    }

    private static String unquote(String input) {
        if (input.length() < 2) {
            return input;
        }
        if (input.startsWith("'") && input.endsWith("'") || input.startsWith("\"") && input.endsWith("\"")) {
            return input.substring(1, input.length() - 1);
        }
        return input;
    }
}

