/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.hologram.base;

import me.filoghost.holographicdisplays.common.PositionCoordinates;
import me.filoghost.holographicdisplays.plugin.hologram.base.BaseHologram;
import me.filoghost.holographicdisplays.plugin.hologram.base.BaseHologramLine;
import me.filoghost.holographicdisplays.plugin.hologram.base.ClickCallbackProvider;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public abstract class BaseClickableHologramLine
extends BaseHologramLine
implements ClickCallbackProvider {
    protected BaseClickableHologramLine(BaseHologram hologram) {
        super(hologram);
    }

    public void onClick(Player player) {
        if (this.hasClickCallback() && this.canInteract(player) && this.isInClickRange(player)) {
            this.invokeClickCallback(player);
        }
    }

    private boolean isInClickRange(Player player) {
        double zDiff;
        double yDiff;
        Location playerLocation = player.getLocation();
        PositionCoordinates position = this.getPosition();
        double xDiff = playerLocation.getX() - position.getX();
        double distanceSquared = xDiff * xDiff + (yDiff = playerLocation.getY() + 1.3 - position.getY()) * yDiff + (zDiff = playerLocation.getZ() - position.getZ()) * zDiff;
        return distanceSquared < 25.0;
    }
}

