/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.hologram.base;

import me.filoghost.holographicdisplays.plugin.hologram.base.BaseHologramComponent;
import me.filoghost.holographicdisplays.plugin.hologram.base.BaseHologramLines;
import me.filoghost.holographicdisplays.plugin.hologram.base.EditableHologramLine;
import me.filoghost.holographicdisplays.plugin.hologram.base.HologramPosition;
import me.filoghost.holographicdisplays.plugin.hologram.base.ImmutablePosition;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.LineTrackerManager;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Preconditions;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseHologram
extends BaseHologramComponent {
    private final HologramPosition hologramPosition;
    private final LineTrackerManager lineTrackerManager;

    public BaseHologram(ImmutablePosition position, LineTrackerManager lineTrackerManager) {
        this.hologramPosition = new HologramPosition(position);
        this.lineTrackerManager = lineTrackerManager;
    }

    public abstract BaseHologramLines<? extends EditableHologramLine> getLines();

    protected abstract boolean isVisibleTo(Player var1);

    public abstract Plugin getCreatorPlugin();

    protected final LineTrackerManager getTrackerManager() {
        return this.lineTrackerManager;
    }

    @Override
    public final void setDeleted() {
        super.setDeleted();
        this.getLines().setDeleted();
    }

    @NotNull
    public ImmutablePosition getPosition() {
        return this.hologramPosition.getPosition();
    }

    @Nullable
    public World getWorldIfLoaded() {
        return this.hologramPosition.getWorldIfLoaded();
    }

    public void setPosition(@NotNull Location location) {
        Preconditions.notNull(location, "location");
        Preconditions.notNull(location.getWorld(), "location.getWorld()");
        this.setPosition(location.getWorld().getName(), location.getX(), location.getY(), location.getZ());
    }

    public void setPosition(@NotNull World world, double x, double y, double z) {
        Preconditions.notNull(world, "world");
        this.setPosition(world.getName(), x, y, z);
    }

    public void setPosition(@NotNull String worldName, double x, double y, double z) {
        Preconditions.notNull(worldName, "worldName");
        this.setPosition(new ImmutablePosition(worldName, x, y, z));
    }

    public void setPosition(@NotNull ImmutablePosition position) {
        Preconditions.notNull(position, "position");
        this.checkNotDeleted();
        this.hologramPosition.set(position);
        this.getLines().updatePositions();
    }

    protected void onWorldLoad(World world) {
        this.hologramPosition.onWorldLoad(world);
    }

    protected void onWorldUnload(World world) {
        this.hologramPosition.onWorldUnload(world);
    }

    protected void onChunkLoad(Chunk chunk) {
        this.hologramPosition.onChunkLoad(chunk);
    }

    protected void onChunkUnload(Chunk chunk) {
        this.hologramPosition.onChunkUnload(chunk);
    }

    protected boolean isInLoadedChunk() {
        return this.hologramPosition.isChunkLoaded();
    }

    public String toString() {
        return "Hologram{position=" + this.hologramPosition.getPosition() + ", lines=" + this.getLines() + ", deleted=" + this.isDeleted() + "}";
    }
}

