/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.hologram.base;

import me.filoghost.holographicdisplays.common.PositionCoordinates;
import me.filoghost.holographicdisplays.plugin.hologram.base.BaseHologram;
import me.filoghost.holographicdisplays.plugin.hologram.base.BaseHologramComponent;
import me.filoghost.holographicdisplays.plugin.hologram.base.EditableHologramLine;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.LineTracker;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.LineTrackerManager;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Preconditions;
import org.bukkit.GameMode;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseHologramLine
extends BaseHologramComponent
implements EditableHologramLine {
    private final BaseHologram hologram;
    private final LineTracker<?> tracker;
    private PositionCoordinates position;

    protected BaseHologramLine(BaseHologram hologram) {
        Preconditions.notNull(hologram, "hologram");
        this.hologram = hologram;
        this.tracker = this.createTracker(hologram.getTrackerManager());
    }

    protected abstract LineTracker<?> createTracker(LineTrackerManager var1);

    public final void setChanged() {
        this.tracker.setLineChanged();
    }

    protected final boolean isViewer(Player player) {
        return this.tracker.isViewer(player);
    }

    @Override
    public final void setPosition(double x, double y, double z) {
        this.position = new PositionCoordinates(x, y, z);
        this.setChanged();
    }

    @NotNull
    public PositionCoordinates getPosition() {
        if (this.position == null) {
            throw new IllegalStateException("position not set");
        }
        return this.position;
    }

    @Nullable
    public World getWorldIfLoaded() {
        return this.hologram.getWorldIfLoaded();
    }

    public boolean isInLoadedChunk() {
        return this.hologram.isInLoadedChunk();
    }

    public final boolean isVisibleTo(Player player) {
        return this.hologram.isVisibleTo(player);
    }

    public final Plugin getCreatorPlugin() {
        return this.hologram.getCreatorPlugin();
    }

    protected boolean canInteract(Player player) {
        return !this.isDeleted() && player.isOnline() && player.getGameMode() != GameMode.SPECTATOR && this.isViewer(player) && this.isVisibleTo(player);
    }
}

