/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.hologram.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import me.filoghost.holographicdisplays.plugin.config.Settings;
import me.filoghost.holographicdisplays.plugin.hologram.base.BaseHologram;
import me.filoghost.holographicdisplays.plugin.hologram.base.EditableHologramLine;
import me.filoghost.holographicdisplays.plugin.hologram.base.ImmutablePosition;
import org.jetbrains.annotations.NotNull;

public class BaseHologramLines<T extends EditableHologramLine>
implements Iterable<T> {
    private final BaseHologram hologram;
    private final List<T> lines;
    private final List<T> unmodifiableLinesView;

    public BaseHologramLines(BaseHologram hologram) {
        this.hologram = hologram;
        this.lines = new ArrayList<T>();
        this.unmodifiableLinesView = Collections.unmodifiableList(this.lines);
    }

    @Override
    public Iterator<T> iterator() {
        return this.unmodifiableLinesView.iterator();
    }

    public int size() {
        return this.lines.size();
    }

    public boolean isEmpty() {
        return this.lines.isEmpty();
    }

    @NotNull
    public T get(int index) {
        return (T)((EditableHologramLine)this.lines.get(index));
    }

    public void add(T line) {
        this.checkNotDeleted();
        this.lines.add(line);
        this.updatePositions();
    }

    public void addAll(List<? extends T> newLines) {
        this.checkNotDeleted();
        this.lines.addAll(newLines);
        this.updatePositions();
    }

    public void insert(int beforeIndex, T line) {
        this.checkNotDeleted();
        this.lines.add(beforeIndex, line);
        this.updatePositions();
    }

    public void set(int index, T line) {
        this.checkNotDeleted();
        EditableHologramLine previousLine = (EditableHologramLine)this.lines.set(index, line);
        previousLine.setDeleted();
        this.updatePositions();
    }

    public void setAll(List<T> newLines) {
        this.checkNotDeleted();
        this.clear();
        this.lines.addAll(newLines);
        this.updatePositions();
    }

    public void remove(int index) {
        this.checkNotDeleted();
        ((EditableHologramLine)this.lines.remove(index)).setDeleted();
        this.updatePositions();
    }

    public boolean remove(T line) {
        this.checkNotDeleted();
        boolean removed = this.lines.remove(line);
        if (removed) {
            line.setDeleted();
            this.updatePositions();
        }
        return removed;
    }

    public void clear() {
        this.checkNotDeleted();
        Iterator<T> iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            EditableHologramLine line = (EditableHologramLine)iterator.next();
            iterator.remove();
            line.setDeleted();
        }
    }

    public void updatePositions() {
        ImmutablePosition hologramPosition = this.hologram.getPosition();
        double currentLineY = hologramPosition.getY();
        for (int i = 0; i < this.lines.size(); ++i) {
            EditableHologramLine line = (EditableHologramLine)this.lines.get(i);
            currentLineY -= line.getHeight();
            if (i > 0) {
                currentLineY -= Settings.spaceBetweenLines;
            }
            line.setPosition(hologramPosition.getX(), currentLineY, hologramPosition.getZ());
        }
    }

    public double getHeight() {
        if (this.isEmpty()) {
            return 0.0;
        }
        double height = 0.0;
        for (EditableHologramLine line : this.lines) {
            height += line.getHeight();
        }
        return height += Settings.spaceBetweenLines * (double)(this.lines.size() - 1);
    }

    public void setDeleted() {
        for (EditableHologramLine line : this.lines) {
            line.setDeleted();
        }
    }

    protected void checkNotDeleted() {
        this.hologram.checkNotDeleted();
    }

    public String toString() {
        return this.lines.toString();
    }
}

