/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.hologram.base;

import me.filoghost.holographicdisplays.plugin.hologram.base.BaseClickableHologramLine;
import me.filoghost.holographicdisplays.plugin.hologram.base.BaseHologram;
import me.filoghost.holographicdisplays.plugin.hologram.base.PickupCallbackProvider;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.ItemLineTracker;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.LineTrackerManager;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Preconditions;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class BaseItemHologramLine
extends BaseClickableHologramLine
implements PickupCallbackProvider {
    private ItemStack itemStack;

    public BaseItemHologramLine(BaseHologram hologram, ItemStack itemStack) {
        super(hologram);
        this.setItemStack(itemStack);
    }

    public ItemLineTracker createTracker(LineTrackerManager trackerManager) {
        return trackerManager.startTracking(this);
    }

    public void onPickup(Player player) {
        if (this.hasPickupCallback() && this.canInteract(player)) {
            this.invokePickupCallback(player);
        }
    }

    @Nullable
    public ItemStack getItemStack() {
        return this.clone(this.itemStack);
    }

    public void setItemStack(@Nullable ItemStack itemStack) {
        this.checkNotDeleted();
        if (itemStack != null) {
            Preconditions.checkArgument(0 < itemStack.getAmount() && itemStack.getAmount() <= 64, "itemStack.getAmount() must be between 1 and 64");
        }
        this.itemStack = this.clone(itemStack);
        this.setChanged();
    }

    private ItemStack clone(@Nullable ItemStack itemStack) {
        return itemStack != null ? itemStack.clone() : null;
    }

    @Override
    public double getHeight() {
        return 0.7;
    }

    public String toString() {
        return "ItemLine{itemStack=" + this.itemStack + "}";
    }
}

