/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.hologram.base;

import java.util.Locale;
import me.filoghost.holographicdisplays.api.beta.Position;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Preconditions;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImmutablePosition
implements Position {
    @NotNull
    private final String worldName;
    private final double x;
    private final double y;
    private final double z;

    public ImmutablePosition(@NotNull String worldName, double x, double y, double z) {
        Preconditions.notNull(worldName, "worldName");
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static ImmutablePosition of(@NotNull Location location) {
        Preconditions.notNull(location, "location");
        Preconditions.notNull(location.getWorld(), "location.getWorld()");
        return new ImmutablePosition(location.getWorld().getName(), location.getX(), location.getY(), location.getZ());
    }

    public static ImmutablePosition of(@NotNull Position position) {
        Preconditions.notNull(position, "position");
        if (position instanceof ImmutablePosition) {
            return (ImmutablePosition)position;
        }
        return new ImmutablePosition(position.getWorldName(), position.getX(), position.getY(), position.getZ());
    }

    @Override
    @NotNull
    public String getWorldName() {
        return this.worldName;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    @Nullable
    public World getWorldIfLoaded() {
        return Bukkit.getWorld((String)this.worldName);
    }

    @Override
    public boolean isInSameWorld(@NotNull Position position) {
        Preconditions.notNull(position, "position");
        return this.isInWorld(position.getWorldName());
    }

    @Override
    public boolean isInSameWorld(@NotNull Location location) {
        Preconditions.notNull(location, "location");
        return this.isInWorld(location.getWorld());
    }

    @Override
    public boolean isInSameWorld(@NotNull Entity entity) {
        Preconditions.notNull(entity, "entity");
        return this.isInWorld(entity.getWorld());
    }

    @Override
    public boolean isInWorld(@Nullable World world) {
        return world != null && this.isInWorld(world.getName());
    }

    @Override
    public boolean isInWorld(@Nullable String worldName) {
        return worldName != null && worldName.toLowerCase(Locale.ENGLISH).equals(this.worldName.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public int getBlockX() {
        return Location.locToBlock((double)this.x);
    }

    @Override
    public int getBlockY() {
        return Location.locToBlock((double)this.y);
    }

    @Override
    public int getBlockZ() {
        return Location.locToBlock((double)this.z);
    }

    @Override
    @NotNull
    public ImmutablePosition add(double x, double y, double z) {
        return new ImmutablePosition(this.worldName, this.x + x, this.y + y, this.z + z);
    }

    @Override
    @NotNull
    public ImmutablePosition subtract(double x, double y, double z) {
        return new ImmutablePosition(this.worldName, this.x - x, this.y - y, this.z - z);
    }

    @NotNull
    public ImmutablePosition withX(double x) {
        return new ImmutablePosition(this.worldName, x, this.y, this.z);
    }

    @NotNull
    public ImmutablePosition withY(double y) {
        return new ImmutablePosition(this.worldName, this.x, y, this.z);
    }

    @NotNull
    public ImmutablePosition withZ(double z) {
        return new ImmutablePosition(this.worldName, this.x, this.y, z);
    }

    @Override
    public double distance(@NotNull Position position) {
        return Math.sqrt(this.distanceSquared(position));
    }

    @Override
    public double distance(@NotNull Location location) {
        return Math.sqrt(this.distanceSquared(location));
    }

    @Override
    public double distance(@NotNull Entity entity) {
        return Math.sqrt(this.distanceSquared(entity));
    }

    @Override
    public double distanceSquared(@NotNull Position position) {
        Preconditions.notNull(position, "position");
        this.checkSameWorld(position.getWorldName());
        return NumberConversions.square((double)(this.x - position.getX())) + NumberConversions.square((double)(this.y - position.getY())) + NumberConversions.square((double)(this.z - position.getZ()));
    }

    @Override
    public double distanceSquared(@NotNull Location location) {
        Preconditions.notNull(location, "location");
        Preconditions.notNull(location.getWorld(), "location.getWorld()");
        this.checkSameWorld(location.getWorld().getName());
        return NumberConversions.square((double)(this.x - location.getX())) + NumberConversions.square((double)(this.y - location.getY())) + NumberConversions.square((double)(this.z - location.getZ()));
    }

    @Override
    public double distanceSquared(@NotNull Entity entity) {
        Preconditions.notNull(entity, "entity");
        return this.distanceSquared(entity.getLocation());
    }

    private void checkSameWorld(String worldName) {
        Preconditions.checkArgument(this.isInWorld(worldName), "cannot measure distance between " + this.worldName + " and " + worldName);
    }

    @Override
    @NotNull
    public Location toLocation() {
        return new Location(this.getWorldIfLoaded(), this.x, this.y, this.z);
    }

    @Override
    @NotNull
    public Vector toVector() {
        return new Vector(this.x, this.y, this.z);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutablePosition other = (ImmutablePosition)obj;
        return this.worldName.equals(other.worldName) && Double.doubleToLongBits(this.x) == Double.doubleToLongBits(other.x) && Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y) && Double.doubleToLongBits(this.z) == Double.doubleToLongBits(other.z);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.worldName.hashCode();
        result = 31 * result + Double.hashCode(this.x);
        result = 31 * result + Double.hashCode(this.y);
        result = 31 * result + Double.hashCode(this.z);
        return result;
    }

    public String toString() {
        return "Position{worldName=" + this.worldName + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + "}";
    }
}

