/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.hologram.tracking;

import me.filoghost.holographicdisplays.common.PositionCoordinates;
import me.filoghost.holographicdisplays.nms.common.NMSManager;
import me.filoghost.holographicdisplays.nms.common.entity.ClickableNMSPacketEntity;
import me.filoghost.holographicdisplays.plugin.hologram.base.BaseClickableHologramLine;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.PositionBasedLineTracker;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.Viewer;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.Viewers;
import me.filoghost.holographicdisplays.plugin.listener.LineClickListener;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public abstract class ClickableLineTracker<T extends Viewer>
extends PositionBasedLineTracker<T> {
    private final ClickableNMSPacketEntity clickableEntity;
    private final double positionOffsetY;
    private final LineClickListener lineClickListener;
    private boolean spawnClickableEntity;
    private boolean spawnClickableEntityChanged;

    public ClickableLineTracker(BaseClickableHologramLine line, NMSManager nmsManager, LineClickListener lineClickListener) {
        this.clickableEntity = nmsManager.newClickablePacketEntity();
        this.positionOffsetY = (line.getHeight() - 0.5) / 2.0;
        this.lineClickListener = lineClickListener;
    }

    @Override
    protected abstract BaseClickableHologramLine getLine();

    @Override
    @MustBeInvokedByOverriders
    public void onRemoval() {
        super.onRemoval();
        this.lineClickListener.unregisterLine(this.clickableEntity.getID());
    }

    @Override
    @MustBeInvokedByOverriders
    protected void detectChanges() {
        super.detectChanges();
        boolean spawnClickableEntity = this.getLine().hasClickCallback();
        if (this.spawnClickableEntity != spawnClickableEntity) {
            this.spawnClickableEntity = spawnClickableEntity;
            this.spawnClickableEntityChanged = true;
            if (spawnClickableEntity) {
                this.lineClickListener.registerLine(this.clickableEntity.getID(), this.getLine());
            } else {
                this.lineClickListener.unregisterLine(this.clickableEntity.getID());
            }
        }
    }

    @Override
    @MustBeInvokedByOverriders
    protected void clearDetectedChanges() {
        super.clearDetectedChanges();
        this.spawnClickableEntityChanged = false;
    }

    @Override
    @MustBeInvokedByOverriders
    protected void sendSpawnPackets(Viewers<T> viewers) {
        if (this.spawnClickableEntity) {
            viewers.sendPackets(this.clickableEntity.newSpawnPackets(this.getClickableEntityPosition()));
        }
    }

    @Override
    @MustBeInvokedByOverriders
    protected void sendDestroyPackets(Viewers<T> viewers) {
        if (this.spawnClickableEntity) {
            viewers.sendPackets(this.clickableEntity.newDestroyPackets());
        }
    }

    @Override
    @MustBeInvokedByOverriders
    protected void sendChangesPackets(Viewers<T> viewers) {
        super.sendChangesPackets(viewers);
        if (this.spawnClickableEntityChanged) {
            if (this.spawnClickableEntity) {
                viewers.sendPackets(this.clickableEntity.newSpawnPackets(this.getClickableEntityPosition()));
            } else {
                viewers.sendPackets(this.clickableEntity.newDestroyPackets());
            }
        }
    }

    @Override
    @MustBeInvokedByOverriders
    protected void sendPositionChangePackets(Viewers<T> viewers) {
        if (this.spawnClickableEntity) {
            viewers.sendPackets(this.clickableEntity.newTeleportPackets(this.getClickableEntityPosition()));
        }
    }

    private PositionCoordinates getClickableEntityPosition() {
        return this.position.addY(this.positionOffsetY);
    }
}

