/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.hologram.tracking;

import java.util.Collection;
import java.util.Objects;
import me.filoghost.holographicdisplays.nms.common.NMSManager;
import me.filoghost.holographicdisplays.nms.common.entity.ItemNMSPacketEntity;
import me.filoghost.holographicdisplays.plugin.hologram.base.BaseItemHologramLine;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.ClickableLineTracker;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.CollisionHelper;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.Viewer;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.Viewers;
import me.filoghost.holographicdisplays.plugin.listener.LineClickListener;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public class ItemLineTracker
extends ClickableLineTracker<Viewer> {
    private final BaseItemHologramLine line;
    private final ItemNMSPacketEntity itemEntity;
    private ItemStack itemStack;
    private boolean itemStackChanged;
    private boolean spawnItemEntity;
    private boolean spawnItemEntityChanged;

    public ItemLineTracker(BaseItemHologramLine line, NMSManager nmsManager, LineClickListener lineClickListener) {
        super(line, nmsManager, lineClickListener);
        this.line = line;
        this.itemEntity = nmsManager.newItemPacketEntity();
    }

    @Override
    public BaseItemHologramLine getLine() {
        return this.line;
    }

    @Override
    @MustBeInvokedByOverriders
    protected void update(Collection<? extends Player> onlinePlayers) {
        super.update(onlinePlayers);
        if (this.spawnItemEntity && this.hasViewers() && this.line.hasPickupCallback()) {
            for (Viewer viewer : this.getViewers()) {
                if (!CollisionHelper.isInPickupRange(viewer.getPlayer(), this.position)) continue;
                this.line.onPickup(viewer.getPlayer());
            }
        }
    }

    @Override
    protected boolean updatePlaceholders() {
        return false;
    }

    @Override
    protected Viewer createViewer(Player player) {
        return new Viewer(player);
    }

    @Override
    @MustBeInvokedByOverriders
    protected void detectChanges() {
        boolean spawnItemEntity;
        super.detectChanges();
        ItemStack itemStack = this.line.getItemStack();
        if (!Objects.equals(this.itemStack, itemStack)) {
            this.itemStack = itemStack;
            this.itemStackChanged = true;
        }
        boolean bl = spawnItemEntity = itemStack != null;
        if (this.spawnItemEntity != spawnItemEntity) {
            this.spawnItemEntity = spawnItemEntity;
            this.spawnItemEntityChanged = true;
        }
    }

    @Override
    @MustBeInvokedByOverriders
    protected void clearDetectedChanges() {
        super.clearDetectedChanges();
        this.itemStackChanged = false;
        this.spawnItemEntityChanged = false;
    }

    @Override
    @MustBeInvokedByOverriders
    protected void sendSpawnPackets(Viewers<Viewer> viewers) {
        super.sendSpawnPackets(viewers);
        if (this.spawnItemEntity) {
            viewers.sendPackets(this.itemEntity.newSpawnPackets(this.position, this.itemStack));
        }
    }

    @Override
    @MustBeInvokedByOverriders
    protected void sendDestroyPackets(Viewers<Viewer> viewers) {
        super.sendDestroyPackets(viewers);
        if (this.spawnItemEntity) {
            viewers.sendPackets(this.itemEntity.newDestroyPackets());
        }
    }

    @Override
    @MustBeInvokedByOverriders
    protected void sendChangesPackets(Viewers<Viewer> viewers) {
        super.sendChangesPackets(viewers);
        if (this.spawnItemEntityChanged) {
            if (this.spawnItemEntity) {
                viewers.sendPackets(this.itemEntity.newSpawnPackets(this.position, this.itemStack));
            } else {
                viewers.sendPackets(this.itemEntity.newDestroyPackets());
            }
        } else if (this.itemStackChanged) {
            viewers.sendPackets(this.itemEntity.newChangePackets(this.itemStack));
        }
    }

    @Override
    @MustBeInvokedByOverriders
    protected void sendPositionChangePackets(Viewers<Viewer> viewers) {
        super.sendPositionChangePackets(viewers);
        if (this.spawnItemEntity) {
            viewers.sendPackets(this.itemEntity.newTeleportPackets(this.position));
        }
    }
}

