/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.hologram.tracking;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import me.filoghost.holographicdisplays.plugin.hologram.base.BaseHologramLine;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.MutableViewers;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.Viewer;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.Viewers;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public abstract class LineTracker<T extends Viewer> {
    private final Map<Player, T> viewers = new HashMap<Player, T>();
    private final Viewers<T> iterableViewers = action -> this.viewers.values().forEach(action);
    private boolean lineChanged;

    protected LineTracker() {
    }

    protected abstract BaseHologramLine getLine();

    final boolean shouldBeRemoved() {
        return this.getLine().isDeleted();
    }

    @MustBeInvokedByOverriders
    public void onRemoval() {
        this.resetViewersAndSendDestroyPackets();
    }

    public final void setLineChanged() {
        this.lineChanged = true;
    }

    @MustBeInvokedByOverriders
    protected void update(Collection<? extends Player> onlinePlayers) {
        boolean sendChangesPackets = false;
        if (this.lineChanged) {
            this.lineChanged = false;
            this.detectChanges();
            sendChangesPackets = true;
        }
        if (this.updatePlaceholders()) {
            sendChangesPackets = true;
        }
        if (sendChangesPackets) {
            if (this.hasViewers()) {
                this.sendChangesPackets(this.iterableViewers);
            }
            this.clearDetectedChanges();
        }
        this.modifyViewersAndSendPackets(onlinePlayers);
    }

    protected abstract void detectChanges();

    protected abstract void clearDetectedChanges();

    protected abstract boolean updatePlaceholders();

    private void modifyViewersAndSendPackets(Collection<? extends Player> onlinePlayers) {
        if (!this.getLine().isInLoadedChunk()) {
            this.resetViewersAndSendDestroyPackets();
            return;
        }
        MutableViewers<T> addedPlayers = null;
        MutableViewers<T> removedPlayers = null;
        for (Player player : onlinePlayers) {
            Object viewer;
            if (this.shouldTrackPlayer(player)) {
                if (this.viewers.containsKey(player)) continue;
                viewer = this.createViewer(player);
                this.viewers.put(player, viewer);
                if (addedPlayers == null) {
                    addedPlayers = new MutableViewers<T>();
                }
                addedPlayers.add(viewer);
                continue;
            }
            if (!this.viewers.containsKey(player)) continue;
            viewer = (Viewer)this.viewers.remove(player);
            if (removedPlayers == null) {
                removedPlayers = new MutableViewers<T>();
            }
            removedPlayers.add(viewer);
        }
        if (addedPlayers != null) {
            this.sendSpawnPackets(addedPlayers);
        }
        if (removedPlayers != null) {
            this.sendDestroyPackets(removedPlayers);
        }
    }

    protected abstract T createViewer(Player var1);

    protected abstract boolean shouldTrackPlayer(Player var1);

    protected final boolean hasViewers() {
        return !this.viewers.isEmpty();
    }

    protected final Collection<T> getViewers() {
        return this.viewers.values();
    }

    public final boolean isViewer(Player player) {
        return this.viewers.containsKey(player);
    }

    protected final void removeViewer(Player player) {
        this.viewers.remove(player);
    }

    protected final void resetViewersAndSendDestroyPackets() {
        if (!this.hasViewers()) {
            return;
        }
        this.sendDestroyPackets(this.iterableViewers);
        this.viewers.clear();
    }

    protected abstract void sendSpawnPackets(Viewers<T> var1);

    protected abstract void sendDestroyPackets(Viewers<T> var1);

    protected abstract void sendChangesPackets(Viewers<T> var1);
}

