/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.hologram.tracking;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import me.filoghost.holographicdisplays.nms.common.NMSManager;
import me.filoghost.holographicdisplays.plugin.hologram.base.BaseItemHologramLine;
import me.filoghost.holographicdisplays.plugin.hologram.base.BaseTextHologramLine;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.ItemLineTracker;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.LineTracker;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.TextLineTracker;
import me.filoghost.holographicdisplays.plugin.listener.LineClickListener;
import me.filoghost.holographicdisplays.plugin.placeholder.tracking.ActivePlaceholderTracker;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class LineTrackerManager {
    private final NMSManager nmsManager;
    private final ActivePlaceholderTracker placeholderTracker;
    private final LineClickListener lineClickListener;
    private final Collection<LineTracker<?>> lineTrackers;

    public LineTrackerManager(NMSManager nmsManager, ActivePlaceholderTracker placeholderTracker, LineClickListener lineClickListener) {
        this.nmsManager = nmsManager;
        this.placeholderTracker = placeholderTracker;
        this.lineClickListener = lineClickListener;
        this.lineTrackers = new LinkedList();
    }

    public TextLineTracker startTracking(BaseTextHologramLine line) {
        TextLineTracker tracker = new TextLineTracker(line, this.nmsManager, this.lineClickListener, this.placeholderTracker);
        this.lineTrackers.add(tracker);
        return tracker;
    }

    public ItemLineTracker startTracking(BaseItemHologramLine line) {
        ItemLineTracker tracker = new ItemLineTracker(line, this.nmsManager, this.lineClickListener);
        this.lineTrackers.add(tracker);
        return tracker;
    }

    public void update() {
        Collection onlinePlayers = Bukkit.getOnlinePlayers();
        Iterator<LineTracker<?>> iterator = this.lineTrackers.iterator();
        while (iterator.hasNext()) {
            LineTracker<?> lineTracker = iterator.next();
            if (lineTracker.shouldBeRemoved()) {
                iterator.remove();
                lineTracker.onRemoval();
                continue;
            }
            lineTracker.update(onlinePlayers);
        }
    }

    public void resetViewersAndSendDestroyPackets() {
        for (LineTracker<?> tracker : this.lineTrackers) {
            tracker.resetViewersAndSendDestroyPackets();
        }
    }

    public void onPlayerQuit(Player player) {
        for (LineTracker<?> tracker : this.lineTrackers) {
            tracker.removeViewer(player);
        }
    }
}

