/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.hologram.tracking;

import java.util.Objects;
import me.filoghost.holographicdisplays.common.PositionCoordinates;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.LineTracker;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.Viewer;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.Viewers;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

abstract class PositionBasedLineTracker<T extends Viewer>
extends LineTracker<T> {
    private static final int ENTITY_VIEW_RANGE = 64;
    protected PositionCoordinates position;
    private boolean positionChanged;

    PositionBasedLineTracker() {
    }

    @Override
    @MustBeInvokedByOverriders
    protected void detectChanges() {
        PositionCoordinates position = this.getLine().getPosition();
        if (!Objects.equals(this.position, position)) {
            this.position = position;
            this.positionChanged = true;
        }
    }

    @Override
    @MustBeInvokedByOverriders
    protected void clearDetectedChanges() {
        this.positionChanged = false;
    }

    @Override
    protected final boolean shouldTrackPlayer(Player player) {
        Location playerLocation = player.getLocation();
        if (playerLocation.getWorld() != this.getLine().getWorldIfLoaded()) {
            return false;
        }
        double diffX = Math.abs(playerLocation.getX() - this.position.getX());
        double diffZ = Math.abs(playerLocation.getZ() - this.position.getZ());
        return diffX <= 64.0 && diffZ <= 64.0 && this.getLine().isVisibleTo(player);
    }

    @Override
    @MustBeInvokedByOverriders
    protected void sendChangesPackets(Viewers<T> viewers) {
        if (this.positionChanged) {
            this.sendPositionChangePackets(viewers);
        }
    }

    protected abstract void sendPositionChangePackets(Viewers<T> var1);
}

