/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.hologram.tracking;

import java.util.Objects;
import me.filoghost.holographicdisplays.nms.common.IndividualTextPacketGroup;
import me.filoghost.holographicdisplays.nms.common.NMSManager;
import me.filoghost.holographicdisplays.nms.common.entity.TextNMSPacketEntity;
import me.filoghost.holographicdisplays.plugin.hologram.base.BaseTextHologramLine;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.ClickableLineTracker;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.DisplayText;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.TextLineViewer;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.Viewers;
import me.filoghost.holographicdisplays.plugin.listener.LineClickListener;
import me.filoghost.holographicdisplays.plugin.placeholder.tracking.ActivePlaceholderTracker;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public class TextLineTracker
extends ClickableLineTracker<TextLineViewer> {
    private final BaseTextHologramLine line;
    private final TextNMSPacketEntity textEntity;
    private final DisplayText displayText;
    private boolean displayTextChanged;

    public TextLineTracker(BaseTextHologramLine line, NMSManager nmsManager, LineClickListener lineClickListener, ActivePlaceholderTracker placeholderTracker) {
        super(line, nmsManager, lineClickListener);
        this.line = line;
        this.textEntity = nmsManager.newTextPacketEntity();
        this.displayText = new DisplayText(placeholderTracker);
    }

    @Override
    public BaseTextHologramLine getLine() {
        return this.line;
    }

    @Override
    protected boolean updatePlaceholders() {
        boolean placeholdersChanged = this.displayText.updateReplacements(this.getViewers());
        if (placeholdersChanged) {
            this.displayTextChanged = true;
        }
        return placeholdersChanged;
    }

    @Override
    protected TextLineViewer createViewer(Player player) {
        return new TextLineViewer(player, this.displayText);
    }

    @Override
    @MustBeInvokedByOverriders
    protected void detectChanges() {
        super.detectChanges();
        String displayText = this.line.getText();
        if (!Objects.equals(this.displayText.getUnreplacedText(), displayText)) {
            this.displayText.setUnreplacedText(displayText);
            this.displayTextChanged = true;
        }
        boolean allowPlaceholders = this.line.isAllowPlaceholders();
        if (this.displayText.isAllowPlaceholders() != allowPlaceholders) {
            this.displayText.setAllowPlaceholders(allowPlaceholders);
            this.displayTextChanged = true;
        }
    }

    @Override
    @MustBeInvokedByOverriders
    protected void clearDetectedChanges() {
        super.clearDetectedChanges();
        this.displayTextChanged = false;
    }

    @Override
    @MustBeInvokedByOverriders
    protected void sendSpawnPackets(Viewers<TextLineViewer> viewers) {
        super.sendSpawnPackets(viewers);
        IndividualTextPacketGroup spawnPackets = this.textEntity.newSpawnPackets(this.position);
        viewers.forEach(viewer -> viewer.sendTextPackets(spawnPackets));
    }

    @Override
    @MustBeInvokedByOverriders
    protected void sendDestroyPackets(Viewers<TextLineViewer> viewers) {
        super.sendDestroyPackets(viewers);
        viewers.sendPackets(this.textEntity.newDestroyPackets());
    }

    @Override
    protected void sendChangesPackets(Viewers<TextLineViewer> viewers) {
        super.sendChangesPackets(viewers);
        if (this.displayTextChanged) {
            IndividualTextPacketGroup changePackets = this.textEntity.newChangePackets();
            viewers.forEach(viewer -> viewer.sendTextPacketsIfNecessary(changePackets));
        }
    }

    @Override
    @MustBeInvokedByOverriders
    protected void sendPositionChangePackets(Viewers<TextLineViewer> viewers) {
        super.sendPositionChangePackets(viewers);
        viewers.sendPackets(this.textEntity.newTeleportPackets(this.position));
    }
}

