/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.hologram.tracking;

import java.util.Objects;
import me.filoghost.holographicdisplays.nms.common.IndividualTextPacketGroup;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.DisplayText;
import me.filoghost.holographicdisplays.plugin.hologram.tracking.Viewer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

class TextLineViewer
extends Viewer {
    private final DisplayText displayText;
    private String individualText;
    private String lastSentText;

    TextLineViewer(Player player, DisplayText displayText) {
        super(player);
        this.displayText = displayText;
    }

    public void sendTextPackets(IndividualTextPacketGroup packets) {
        String text;
        this.lastSentText = text = this.getOrComputeText();
        packets.sendTo(this.getPlayer(), text);
    }

    public void sendTextPacketsIfNecessary(IndividualTextPacketGroup packets) {
        String text = this.getOrComputeText();
        if (Objects.equals(this.lastSentText, text)) {
            return;
        }
        this.lastSentText = text;
        packets.sendTo(this.getPlayer(), text);
    }

    @Nullable
    private String getOrComputeText() {
        if (this.displayText.containsIndividualPlaceholders()) {
            if (this.individualText == null) {
                this.individualText = this.displayText.computeIndividualText(this);
            }
            return this.individualText;
        }
        this.individualText = null;
        return this.displayText.getGlobalText();
    }

    public boolean updateIndividualText(String individualText) {
        if (!Objects.equals(this.individualText, individualText)) {
            this.individualText = individualText;
            return true;
        }
        return false;
    }
}

