/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.internal.placeholder;

import me.filoghost.holographicdisplays.api.beta.placeholder.GlobalPlaceholder;
import me.filoghost.holographicdisplays.api.beta.placeholder.GlobalPlaceholderFactory;
import me.filoghost.holographicdisplays.plugin.bridge.bungeecord.BungeeServerTracker;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Strings;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.Nullable;

public class OnlinePlayersPlaceholderFactory
implements GlobalPlaceholderFactory {
    private final BungeeServerTracker bungeeServerTracker;

    public OnlinePlayersPlaceholderFactory(BungeeServerTracker bungeeServerTracker) {
        this.bungeeServerTracker = bungeeServerTracker;
    }

    @Override
    public GlobalPlaceholder getPlaceholder(@Nullable String argument) {
        if (argument == null) {
            return new LocalOnlinePlayersPlaceholder();
        }
        String[] serverNames = Strings.splitAndTrim(argument, ",");
        return new BungeeOnlinePlayersPlaceholder(serverNames, this.bungeeServerTracker);
    }

    private static class LocalOnlinePlayersPlaceholder
    implements GlobalPlaceholder {
        private LocalOnlinePlayersPlaceholder() {
        }

        @Override
        public int getRefreshIntervalTicks() {
            return 20;
        }

        @Override
        public String getReplacement(@Nullable String argument) {
            return String.valueOf(Bukkit.getOnlinePlayers().size());
        }
    }

    private static class BungeeOnlinePlayersPlaceholder
    implements GlobalPlaceholder {
        private final String[] serverNames;
        private final BungeeServerTracker bungeeServerTracker;

        BungeeOnlinePlayersPlaceholder(String[] serverNames, BungeeServerTracker bungeeServerTracker) {
            this.serverNames = serverNames;
            this.bungeeServerTracker = bungeeServerTracker;
        }

        @Override
        public int getRefreshIntervalTicks() {
            return 20;
        }

        @Override
        public String getReplacement(@Nullable String argument) {
            int count = 0;
            for (String serverName : this.serverNames) {
                count += this.bungeeServerTracker.getCurrentServerInfo(serverName).getOnlinePlayers();
            }
            return String.valueOf(count);
        }
    }
}

