/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.internal.placeholder;

import me.filoghost.holographicdisplays.api.beta.placeholder.GlobalPlaceholder;
import me.filoghost.holographicdisplays.api.beta.placeholder.GlobalPlaceholderFactory;
import me.filoghost.holographicdisplays.plugin.internal.placeholder.ImmutablePlaceholder;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Strings;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class WorldPlayersPlaceholderFactory
implements GlobalPlaceholderFactory {
    @Override
    public GlobalPlaceholder getPlaceholder(@Nullable String argument) {
        if (argument == null) {
            return new ImmutablePlaceholder("[No world specified]");
        }
        String[] worldNames = Strings.splitAndTrim(argument, ",");
        return new WorldPlayersPlaceholder(worldNames);
    }

    private static class WorldPlayersPlaceholder
    implements GlobalPlaceholder {
        private final String[] worldNames;

        WorldPlayersPlaceholder(String[] worldNames) {
            this.worldNames = worldNames;
        }

        @Override
        public int getRefreshIntervalTicks() {
            return 20;
        }

        @Override
        public String getReplacement(@Nullable String argument) {
            int count = 0;
            for (String worldName : this.worldNames) {
                World world = Bukkit.getWorld((String)worldName);
                if (world == null) {
                    return "[World \"" + worldName + "\" not found]";
                }
                for (Player player : world.getPlayers()) {
                    if (player.hasMetadata("NPC")) continue;
                    ++count;
                }
            }
            return String.valueOf(count);
        }
    }
}

