/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.lib.fcommons;

import me.filoghost.holographicdisplays.plugin.lib.fcommons.FeatureSupport;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Strings;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.Nullable;

public final class Colors {
    public static final char ALT_COLOR_CHAR = '&';
    private static final CharArray ALT_COLOR_CODES = new CharArray("0123456789AaBbCcDdEeFfKkLlMmNnOoRr");
    private static final CharArray ALT_HEX_CODES = new CharArray("0123456789AaBbCcDdEeFf");
    private static final int ALT_HEX_COLOR_LENGTH = 6;
    private static final CharArray STANDARD_COLOR_CODES = new CharArray("0123456789abcdefklmnor");
    private static final CharArray STANDARD_HEX_CODES = new CharArray("0123456789abcdef");
    private static final int STANDARD_HEX_COLOR_LENGTH = 12;

    public static String colorize(@Nullable String string) {
        if (Strings.isEmpty(string) || string.indexOf(38) < 0) {
            return string;
        }
        StringBuilder result = new StringBuilder(string.length());
        int i = 0;
        while (i < string.length()) {
            char currentChar = string.charAt(i);
            if (currentChar == '&' && i + 1 < string.length()) {
                char nextChar = string.charAt(i + 1);
                if (nextChar == '#' && FeatureSupport.HEX_CHAT_COLORS && Colors.isAltHexColor(string, i + 2)) {
                    result.append('\u00a7');
                    result.append('x');
                    Colors.translateAltHexColor(string, i + 2, result);
                    i += 8;
                    continue;
                }
                if (ALT_COLOR_CODES.contains(nextChar)) {
                    result.append('\u00a7');
                    result.append(Character.toLowerCase(nextChar));
                    i += 2;
                    continue;
                }
            }
            result.append(currentChar);
            ++i;
        }
        return result.toString();
    }

    private static boolean isAltHexColor(String string, int beginIndex) {
        if (string.length() - beginIndex < 6) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            char hexCode = string.charAt(beginIndex + i);
            if (ALT_HEX_CODES.contains(hexCode)) continue;
            return false;
        }
        return true;
    }

    private static void translateAltHexColor(String string, int beginIndex, StringBuilder output) {
        for (int i = 0; i < 6; ++i) {
            char hexCode = string.charAt(beginIndex + i);
            output.append('\u00a7');
            output.append(Character.toLowerCase(hexCode));
        }
    }

    public static String uncolorize(@Nullable String string) {
        if (Strings.isEmpty(string) || string.indexOf(167) < 0) {
            return string;
        }
        StringBuilder result = new StringBuilder(string.length());
        int i = 0;
        while (i < string.length()) {
            char currentChar = string.charAt(i);
            if (currentChar == '\u00a7' && i + 1 < string.length()) {
                char nextChar = string.charAt(i + 1);
                if (nextChar == 'x' && FeatureSupport.HEX_CHAT_COLORS && Colors.isStandardHexColor(string, i + 2)) {
                    result.append('&');
                    result.append('#');
                    Colors.untranslateStandardHexColor(string, i + 2, result);
                    i += 14;
                    continue;
                }
                if (STANDARD_COLOR_CODES.contains(nextChar)) {
                    result.append('&');
                    result.append(nextChar);
                    i += 2;
                    continue;
                }
            }
            result.append(currentChar);
            ++i;
        }
        return result.toString();
    }

    private static boolean isStandardHexColor(String string, int startIndex) {
        if (string.length() - startIndex < 12) {
            return false;
        }
        for (int i = 0; i < 12; i += 2) {
            char colorChar = string.charAt(startIndex + i);
            char hexCode = string.charAt(startIndex + i + 1);
            if (colorChar == '\u00a7' && STANDARD_HEX_CODES.contains(hexCode)) continue;
            return false;
        }
        return true;
    }

    private static void untranslateStandardHexColor(String string, int beginIndex, StringBuilder output) {
        for (int i = 0; i < 12; i += 2) {
            output.append(string.charAt(beginIndex + i + 1));
        }
    }

    public static String trimTransparentWhitespace(@Nullable String string) {
        String rightPart;
        String leftPart;
        if (Strings.isEmpty(string)) {
            return string;
        }
        int firstVisibleChar = -1;
        int lastVisibleChar = -1;
        int length = string.length();
        boolean whitespaceVisible = false;
        for (int i = 0; i < length; ++i) {
            char currentChar = string.charAt(i);
            if (currentChar == ' ' && !whitespaceVisible) continue;
            if (currentChar == '\u00a7') {
                if (i >= length - 1) continue;
                ChatColor chatColor = ChatColor.getByChar((char)string.charAt(i + 1));
                if (chatColor != null) {
                    if (chatColor == ChatColor.STRIKETHROUGH || chatColor == ChatColor.UNDERLINE) {
                        whitespaceVisible = true;
                    } else if (chatColor == ChatColor.RESET || chatColor.isColor()) {
                        whitespaceVisible = false;
                    }
                }
                ++i;
                continue;
            }
            if (firstVisibleChar == -1) {
                firstVisibleChar = i;
            }
            lastVisibleChar = i + 1;
        }
        if (firstVisibleChar == -1) {
            return string.replace(" ", "");
        }
        String result = string.substring(firstVisibleChar, lastVisibleChar);
        if (firstVisibleChar > 0 && !(leftPart = string.substring(0, firstVisibleChar).replace(" ", "")).isEmpty()) {
            result = leftPart + result;
        }
        if (lastVisibleChar < string.length() && !(rightPart = string.substring(lastVisibleChar).replace(" ", "")).isEmpty()) {
            result = result + rightPart;
        }
        return result;
    }

    public static String optimize(@Nullable String string) {
        if (Strings.isEmpty(string) || string.indexOf(167) < 0) {
            return string;
        }
        int length = string.length();
        StringBuilder result = new StringBuilder(length);
        StringBuilder previousColors = new StringBuilder();
        StringBuilder newColors = new StringBuilder();
        int i = 0;
        while (i < length) {
            char currentChar = string.charAt(i);
            if (currentChar == '\u00a7' && i < length - 1) {
                newColors.append(currentChar);
                newColors.append(string.charAt(i + 1));
                i += 2;
                continue;
            }
            if (newColors.length() > 0) {
                if (!Colors.contentEquals(newColors, previousColors)) {
                    result.append((CharSequence)newColors);
                }
                previousColors.setLength(0);
                previousColors.append((CharSequence)newColors);
                newColors.setLength(0);
            }
            result.append(currentChar);
            ++i;
        }
        if (newColors.length() > 0) {
            result.append((CharSequence)newColors);
        }
        return result.toString();
    }

    private static boolean contentEquals(StringBuilder stringBuilder1, StringBuilder stringBuilder2) {
        if (stringBuilder1.length() != stringBuilder2.length()) {
            return false;
        }
        for (int i = 0; i < stringBuilder1.length(); ++i) {
            if (stringBuilder1.charAt(i) == stringBuilder2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static class CharArray {
        private final char[] chars;

        CharArray(String chars) {
            this.chars = chars.toCharArray();
        }

        boolean contains(char c) {
            for (char element : this.chars) {
                if (c != element) continue;
                return true;
            }
            return false;
        }
    }
}

