/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.lib.fcommons;

import java.util.ArrayList;
import java.util.Collection;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Strings {
    public static boolean isEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static String truncate(@Nullable String string, int maxLength) {
        if (string != null && string.length() > maxLength) {
            return string.substring(0, maxLength);
        }
        return string;
    }

    public static String[] trim(String ... strings) {
        String[] output = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            output[i] = strings[i].trim();
        }
        return output;
    }

    public static String[] split(@NotNull String string, @NotNull String delimiter) {
        return Strings.split(string, delimiter, 0);
    }

    public static String[] split(@NotNull String string, @NotNull String delimiter, int limit) {
        int matchIndex;
        Preconditions.notNull(string, "string");
        Preconditions.notEmpty(delimiter, "delimiter");
        Preconditions.checkArgument(limit >= 0, "limit cannot be negative");
        if (string.isEmpty() || limit == 1) {
            return new String[]{string};
        }
        int firstIndex = string.indexOf(delimiter);
        if (firstIndex == -1) {
            return new String[]{string};
        }
        ArrayList<String> parts = null;
        int fromIndex = 0;
        while ((matchIndex = string.indexOf(delimiter, fromIndex)) != -1) {
            if (parts == null) {
                parts = new ArrayList<String>();
            }
            if (limit > 0 && parts.size() >= limit - 1) break;
            parts.add(string.substring(fromIndex, matchIndex));
            fromIndex = matchIndex + delimiter.length();
        }
        if (parts == null || parts.isEmpty()) {
            return new String[]{string};
        }
        parts.add(string.substring(fromIndex));
        return parts.toArray(new String[0]);
    }

    public static String[] splitAndTrim(@NotNull String string, @NotNull String delimiter) {
        return Strings.splitAndTrim(string, delimiter, 0);
    }

    public static String[] splitAndTrim(@NotNull String string, @NotNull String delimiter, int limit) {
        String[] parts = Strings.split(string, delimiter, limit);
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = parts[i].trim();
        }
        return parts;
    }

    public static String joinFrom(@NotNull String separator, String @NotNull [] elements, int fromIndex) {
        return Strings.joinRange(separator, elements, fromIndex, elements.length);
    }

    public static String joinRange(@NotNull String separator, String @NotNull [] elements, int fromIndex, int toIndex) {
        Preconditions.notNull(separator, "separator");
        Preconditions.notNull(elements, "elements");
        Preconditions.checkArgument(fromIndex <= toIndex, "fromIndex (" + fromIndex + ") cannot be greater than toIndex (" + toIndex + ")");
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException("fromIndex (" + fromIndex + ") cannot be negative");
        }
        if (toIndex > elements.length) {
            throw new ArrayIndexOutOfBoundsException("toIndex (" + toIndex + ") cannot be greater than array length (" + elements.length + ")");
        }
        StringBuilder output = new StringBuilder();
        for (int i = fromIndex; i < toIndex; ++i) {
            if (output.length() != 0) {
                output.append(separator);
            }
            output.append(elements[i]);
        }
        return output.toString();
    }

    public static String stripChars(@Nullable String string, char ... charsToRemove) {
        if (Strings.isEmpty(string) || charsToRemove.length == 0) {
            return string;
        }
        StringBuilder output = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Strings.arrayContains(charsToRemove, c)) continue;
            output.append(c);
        }
        return output.toString();
    }

    private static boolean arrayContains(char[] array, char valueToFind) {
        for (char c : array) {
            if (c != valueToFind) continue;
            return true;
        }
        return false;
    }

    public static String capitalizeFully(@Nullable String string) {
        if (Strings.isEmpty(string)) {
            return string;
        }
        string = string.toLowerCase();
        int length = string.length();
        StringBuilder output = new StringBuilder(length);
        boolean capitalizeNext = true;
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                output.append(c);
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                output.append(Character.toTitleCase(c));
                capitalizeNext = false;
                continue;
            }
            output.append(c);
        }
        return output.toString();
    }

    public static String capitalizeFirst(@Nullable String string) {
        if (Strings.isEmpty(string)) {
            return string;
        }
        return Character.toTitleCase(string.charAt(0)) + string.substring(1);
    }

    public static boolean isWhitespace(@Nullable String string) {
        if (Strings.isEmpty(string)) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasSentenceEnding(@Nullable String string) {
        if (Strings.isEmpty(string)) {
            return false;
        }
        char lastChar = string.charAt(string.length() - 1);
        return lastChar == '.' || lastChar == '?' || lastChar == '!';
    }

    public static boolean containsIgnoreCase(@NotNull String[] array, @NotNull String target) {
        for (String element : array) {
            if (!target.equalsIgnoreCase(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIgnoreCase(@NotNull Collection<String> collection, @NotNull String target) {
        for (String element : collection) {
            if (!target.equalsIgnoreCase(element)) continue;
            return true;
        }
        return false;
    }
}

