/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.lib.fcommons.collection;

import java.util.Arrays;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.collection.LookupRegistry;

public class EnumLookupRegistry<E extends Enum<E>>
extends LookupRegistry<E> {
    private final Class<E> enumType;

    public EnumLookupRegistry(Class<E> enumType) {
        this.enumType = enumType;
    }

    public static <E extends Enum<E>> EnumLookupRegistry<E> fromEnumValues(Class<E> enumClass) {
        EnumLookupRegistry<E> registry = new EnumLookupRegistry<E>(enumClass);
        registry.putAll(Arrays.asList(enumClass.getEnumConstants()), Enum::name);
        return registry;
    }

    public void putEnumIfExisting(String key, String enumName) {
        try {
            E value = Enum.valueOf(this.enumType, enumName);
            this.put(key, value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

