/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.lib.fcommons.config;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Preconditions;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Strings;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigSection;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigLoadException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.ConfigSyntaxException;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

class YamlSerializer {
    private static final String COMMENT_PREFIX = "#";
    private static final String BLANK_CONFIG = "{}\n";
    private final Yaml yaml;

    YamlSerializer() {
        DumperOptions yamlOptions = new DumperOptions();
        yamlOptions.setIndent(2);
        yamlOptions.setWidth(Integer.MAX_VALUE);
        yamlOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yaml = new Yaml(yamlOptions);
    }

    public LinkedHashMap<String, Object> parseRawValues(List<String> fileContents) throws ConfigLoadException {
        Preconditions.notNull(fileContents, "fileContents cannot be null");
        Map<?, ?> yamlValues = this.parseYamlMap(String.join((CharSequence)"\n", fileContents));
        if (yamlValues != null) {
            return this.yamlMapToRawValues(yamlValues);
        }
        return null;
    }

    public String serializeConfigValues(LinkedHashMap<String, Object> rawValues) {
        Map<String, Object> yamlMap = this.rawValuesToYamlMap(rawValues);
        return this.serializeYamlMap(yamlMap);
    }

    public List<String> parseHeader(List<String> fileContents) {
        ArrayList<String> headerLines = new ArrayList<String>();
        boolean foundHeader = false;
        for (String line : fileContents) {
            if (line.startsWith(COMMENT_PREFIX)) {
                foundHeader = true;
                int headerCommentStart = COMMENT_PREFIX.length();
                if (line.length() > headerCommentStart && Character.isWhitespace(line.charAt(headerCommentStart))) {
                    ++headerCommentStart;
                }
                String lineContent = line.substring(headerCommentStart);
                headerLines.add(lineContent);
                continue;
            }
            if (!foundHeader && Strings.isWhitespace(line)) continue;
            break;
        }
        return headerLines;
    }

    public String serializeHeader(@Nullable List<String> header) {
        if (header != null && !header.isEmpty()) {
            return header.stream().map(s -> "# " + s + "\n").collect(Collectors.joining()) + "\n";
        }
        return "";
    }

    public LinkedHashMap<String, Object> yamlMapToRawValues(Map<?, ?> yamlMap) {
        LinkedHashMap<String, Object> rawValues = new LinkedHashMap<String, Object>();
        for (Map.Entry<?, ?> entry : yamlMap.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            rawValues.put(key, this.yamlValueToRawValue(value));
        }
        return rawValues;
    }

    private Object yamlValueToRawValue(Object yamlValue) {
        if (yamlValue instanceof Map) {
            Map yamlMap = (Map)yamlValue;
            return new ConfigSection(this.yamlMapToRawValues(yamlMap));
        }
        if (yamlValue instanceof List) {
            List yamlList = (List)yamlValue;
            ArrayList<Object> rawList = new ArrayList<Object>();
            for (Object yamlElement : yamlList) {
                rawList.add(this.yamlValueToRawValue(yamlElement));
            }
            return rawList;
        }
        return yamlValue;
    }

    public Map<String, Object> rawValuesToYamlMap(Map<String, Object> rawValues) {
        LinkedHashMap<String, Object> yamlMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : rawValues.entrySet()) {
            String key = entry.getKey();
            Object rawValue = entry.getValue();
            yamlMap.put(key, this.rawValueToYamlValue(rawValue));
        }
        return yamlMap;
    }

    private Object rawValueToYamlValue(Object rawValue) {
        if (rawValue instanceof ConfigSection) {
            ConfigSection rawSection = (ConfigSection)rawValue;
            return this.rawValuesToYamlMap(rawSection.getRawValues());
        }
        if (rawValue instanceof List) {
            List rawList = (List)rawValue;
            ArrayList<Object> yamlList = new ArrayList<Object>();
            for (Object rawElement : rawList) {
                yamlList.add(this.rawValueToYamlValue(rawElement));
            }
            return yamlList;
        }
        return rawValue;
    }

    private Map<?, ?> parseYamlMap(String serializedYamlMap) throws ConfigSyntaxException {
        Object loadedObject;
        try {
            loadedObject = this.yaml.load(serializedYamlMap);
        }
        catch (YAMLException e) {
            throw new ConfigSyntaxException("invalid YAML syntax", e);
        }
        if (loadedObject == null) {
            return null;
        }
        if (loadedObject instanceof Map) {
            return (Map)loadedObject;
        }
        throw new ConfigSyntaxException("invalid YAML syntax", "Top level is not a Map.");
    }

    private String serializeYamlMap(Map<?, ?> yamlMap) {
        String serializedYamlMap = this.yaml.dump(yamlMap);
        if (serializedYamlMap.equals(BLANK_CONFIG)) {
            serializedYamlMap = "";
        }
        return serializedYamlMap;
    }
}

